/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.StreamUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static List<String> split(String value, String separator) {
        return StringUtils.isEmpty(value) ? Collections.emptyList() : Stream.of(value.split(separator)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static Map<String, String> splitKeyValue(String ... keyValue) {
        return Stream.of(keyValue).map(s -> s.split("=")).collect(StreamUtils.toLinkedMap(s -> s[0], s -> ((String[])s).length == 1 ? "" : s[1]));
    }

    public static int findFirstIndexIn(String keyValue, String chars) {
        return IntStream.range(0, keyValue.length()).filter(i -> {
            char c = keyValue.charAt(i);
            return chars.chars().anyMatch(ch -> ch == c);
        }).findFirst().orElse(-1);
    }

    public static String addOffsets(String value, int spacesCount) {
        StringBuilder result = new StringBuilder(value);
        for (int i = 0; i < spacesCount; ++i) {
            result.append(' ');
        }
        return result.toString();
    }

    public static long dotCountIn(String line) {
        return StringUtils.symbolCountIn(line, '.');
    }

    public static long symbolCountIn(String line, char symbol) {
        return line.chars().filter(c -> c == symbol).count();
    }

    public static String unixLikePath(String path) {
        return path.replace('\\', '/');
    }

    public static String toUnixPathSeparator(String line) {
        return line.replace("\r\n", "\n").trim();
    }

    public static String escape(String value) {
        String one = "\\";
        String two = "\\\\";
        return value.replace(two, one).replace(one, two);
    }

    public static StringBuilder asStringBuilder(CharSequence line) {
        return line instanceof StringBuilder ? (StringBuilder)line : new StringBuilder(line);
    }

    public static String getCauseMessage(Throwable t) {
        return StringUtils.getExceptionMessage(t.getCause());
    }

    public static String getExceptionMessage(Throwable t) {
        return Optional.ofNullable(t).map(throwable -> "Cause: " + throwable.getMessage()).orElse("");
    }

    public static boolean isBlank(String line) {
        return line.chars().allMatch(Character::isWhitespace);
    }

    @Generated
    private StringUtils() {
    }
}

