/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils.reader;

import io.microconfig.utils.IoUtils;
import io.microconfig.utils.reader.FilesReader;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FsFilesReader
implements FilesReader {
    @Override
    public String read(File file) {
        return IoUtils.readFully(file);
    }

    @Override
    public List<String> readLines(File file) {
        return IoUtils.readLines(file);
    }

    @Override
    public Optional<String> firstLine(File file, Predicate<String> predicate) {
        try (Stream<String> lines = IoUtils.lines(file.toPath());){
            Optional<String> optional = lines.filter(predicate).findFirst();
            return optional;
        }
    }
}

