/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public class TimeUtils {
    public static int calcSecFrom(long startTimeMs) {
        return (int)TimeUnit.MILLISECONDS.toSeconds(TimeUtils.calcMsFrom(startTimeMs));
    }

    private static long calcMsFrom(long startTimeMs) {
        return System.currentTimeMillis() - startTimeMs;
    }

    public static String secAfter(long startTimeMs) {
        return TimeUtils.calcSecFrom(startTimeMs) + " sec";
    }

    public static String msAfter(long startTimeMs) {
        return TimeUtils.calcMsFrom(startTimeMs) + " ms";
    }

    public static String formatTimeAfter(long startTime) {
        int sec = TimeUtils.calcSecFrom(startTime);
        int[] times = new int[]{1, 60, 3600, 86400};
        String[] timeUnit = new String[]{"s", "m", "h", "d"};
        IntFunction<String> format = i -> {
            int full = sec / times[i];
            String formatted = full + timeUnit[i];
            if (i == 0) {
                return formatted;
            }
            return formatted + " " + sec % times[i] / times[i - 1] + timeUnit[i - 1];
        };
        for (int i2 = 0; i2 < times.length - 1; ++i2) {
            if (sec >= times[i2 + 1]) continue;
            return format.apply(i2);
        }
        return format.apply(times.length - 1);
    }

    public static Supplier<Integer> percentProgress(int eventCount) {
        AtomicInteger counter = new AtomicInteger();
        return () -> Math.min(100, counter.incrementAndGet() * 100 / eventCount);
    }

    public static <T> T printLongTime(Supplier<T> supplier, String log) {
        long t = System.currentTimeMillis();
        T result = supplier.get();
        int sec = TimeUtils.calcSecFrom(t);
        String message = log + " in " + sec + " sec ";
        if (sec > 5) {
            Logger.warn(message);
        }
        return result;
    }
}

