/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String unixLikePath(String path) {
        return path.replace('\\', '/');
    }

    public static String replaceMultipleSpaces(String line) {
        return line.replaceAll("\\s+", " ").trim();
    }

    public static boolean like(String value, String like) {
        if (value == null || like == null) {
            return false;
        }
        String pattern = Pattern.quote(like).replace("_", "\\E.\\Q").replace("%", "\\E.*\\Q");
        return value.matches(pattern);
    }

    public static List<String> splitToList(String value, String separator) {
        return StringUtils.isEmpty(value) ? Collections.emptyList() : Stream.of(value.split(separator)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static String toLowerHyphen(String name) {
        return name.codePoints().mapToObj(c -> Character.isUpperCase((char)c) ? "-" + Character.toLowerCase((char)c) : Character.toString((char)c)).collect(Collectors.joining());
    }

    public static int indexOfFirstDigitOr(String line, int defaultIndex) {
        for (int i = 0; i < line.length(); ++i) {
            if (!Character.isDigit(line.charAt(i))) continue;
            return i;
        }
        return defaultIndex;
    }

    public static String addOffsets(String value, int spacesCount) {
        StringBuilder result = new StringBuilder(value);
        for (int i = 0; i < spacesCount; ++i) {
            result.append(' ');
        }
        return result.toString();
    }
}

