/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.ConsoleColor;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logger {
    private static volatile boolean errorOccurred;

    public static void error(Throwable e) {
        if (e != null) {
            Logger.error(null, e);
        }
    }

    public static void error(String message, Throwable e) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        if (message != null) {
            writer.println(message);
        }
        if (e != null) {
            e.printStackTrace(writer);
        }
        Logger.error(out.toString());
    }

    public static void error(String message) {
        Logger.info(ConsoleColor.red(message));
        errorOccurred = true;
    }

    public static void warn(String message) {
        Logger.info(ConsoleColor.yellow(message));
    }

    public static void announce(String message) {
        Logger.info(ConsoleColor.green(message));
    }

    public static void info(String message) {
        System.out.println(message);
    }

    public static String align(String value, int spacesCount) {
        return String.format("%1$-" + spacesCount + "s", value);
    }

    public static boolean isErrorOccurred() {
        return errorOccurred;
    }
}

