/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class IoUtils {
    public static String readFullyOrEmpty(File file) {
        return file.exists() ? IoUtils.readFully(file) : "";
    }

    public static String readFully(File file) {
        try {
            return IoUtils.readFully(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFully(InputStream is) {
        String string;
        block9: {
            InputStream input = is;
            try {
                int n;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                string = output.toString();
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return string;
    }

    public static String firstLineOrEmpty(File file) {
        String line = IoUtils.firstLine(file);
        return line == null ? "" : line;
    }

    public static String firstLine(File file) {
        if (!file.exists()) {
            return null;
        }
        try (Stream<String> strings = IoUtils.lines(file.toPath());){
            String string = strings.findFirst().map(String::trim).orElse("");
            return string;
        }
    }

    public static Stream<String> lines(Path path) {
        try {
            return Files.lines(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readLines(File file) {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        try {
            return Files.readAllLines(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

