/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public class FileUtils {
    public static final String LINES_SEPARATOR = System.getProperty("line.separator");

    public static File userHome() {
        return new File(FileUtils.userHomeString());
    }

    public static String userHomeString() {
        return System.getProperty("user.home");
    }

    public static String filename(File original) {
        String name = original.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    public static void truncate(File dir) {
        FileUtils.delete(dir);
        FileUtils.createDir(dir);
    }

    public static File createDir(File dir) {
        if (dir.exists()) {
            return dir;
        }
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return dir;
    }

    public static File createFile(File file) {
        if (file.exists()) {
            return file;
        }
        FileUtils.createDir(file.getParentFile());
        try {
            Files.createFile(file.toPath(), new FileAttribute[0]);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(File file, String content) {
        FileUtils.write(file.toPath(), content, new OpenOption[0]);
    }

    public static void write(Path file, String content, OpenOption ... options) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, content.getBytes(), options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(Path path, Collection<String> lines) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, lines, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void delete(File ... files) {
        if (files != null) {
            Arrays.stream(files).forEach(FileUtils::delete);
        }
    }

    public static void delete(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            if (!path.delete()) {
                Logger.warn("Can't delete file " + path);
            }
        } else if (!FileUtils.deleteDir(path)) {
            Logger.warn("Can't delete dir " + path);
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            Stream.of(dir.listFiles()).forEach(FileUtils::deleteDir);
        }
        return dir.delete();
    }

    public static void copy(File from, File to) {
        FileUtils.copy(from.toPath(), to.toPath());
    }

    public static void copy(Path src, Path dest) {
        if (!Files.exists(src, new LinkOption[0])) {
            FileUtils.delete(dest.toFile());
            return;
        }
        try {
            Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File canonical(File repoDir) {
        try {
            return repoDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean dirNotEmpty(File destination, int minFileCount) {
        return destination.exists() && destination.list().length >= minFileCount;
    }

    public static Stream<Path> walk(Path path) {
        try {
            return Files.walk(path, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String extension(File fileName) {
        int beginIndex = fileName.getName().indexOf(46);
        if (beginIndex < 0) {
            return "";
        }
        return fileName.getName().substring(beginIndex);
    }
}

