/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.CollectionUtils;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.Logger;
import io.microconfig.utils.OsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;

public class FilePermissionUtils {
    public static void copyPermissions(Path from, Path to) {
        if (OsUtil.isWindows()) {
            return;
        }
        try {
            Files.setPosixFilePermissions(to, Files.getPosixFilePermissions(from, new LinkOption[0]));
        }
        catch (IOException e) {
            Logger.error(String.format("Cannot copy file permissions from %s to %s", from, to), e);
        }
    }

    public static void allowExecutionIfExists(File script) {
        if (!script.exists()) {
            return;
        }
        FilePermissionUtils.allowExecution(script.toPath());
    }

    public static void allowExecution(Path file) {
        if (OsUtil.isWindows()) {
            return;
        }
        try {
            Files.setPosixFilePermissions(file, CollectionUtils.setOf(PosixFilePermission.values()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeExecutable(File file, String content) {
        FileUtils.write(file, content);
        FilePermissionUtils.allowExecution(file.toPath());
    }
}

