/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.Logger;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class CommandLineParams {
    private final Map<String, String> keyToValue;

    public static CommandLineParams parse(String[] args) {
        Map<String, String> keyToValue = Stream.of(args).map(a -> a.split("=")).peek(CommandLineParams::checkKeyAndValue).collect(Collectors.toMap(p -> p[0], p -> p[1]));
        return new CommandLineParams(keyToValue);
    }

    public String value(String key) {
        String v = this.keyToValue.get(key);
        return StringUtils.isEmpty(v) ? null : v;
    }

    public List<String> listValue(String key) {
        return StringUtils.splitToList(this.value(key), ",");
    }

    public String requiredValue(String key, String npeMessage) {
        String value = this.value(key);
        if (value != null) {
            return value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        }
        CommandLineParams.printErrorAndExit(npeMessage);
        throw new AssertionError((Object)"Impossible");
    }

    public void putToSystem(String key) {
        String value = this.value(key);
        if (value != null) {
            System.setProperty(key, value);
        }
    }

    private static void checkKeyAndValue(String[] pair) {
        if (pair.length != 2) {
            CommandLineParams.printErrorAndExit("Incorrect command line param " + Arrays.toString(pair));
        }
    }

    private static void printErrorAndExit(String npeMessage) {
        Logger.error(npeMessage);
        System.exit(-1);
    }

    @ConstructorProperties(value={"keyToValue"})
    @Generated
    public CommandLineParams(Map<String, String> keyToValue) {
        this.keyToValue = keyToValue;
    }
}

