/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    public static <T> T singleValue(Collection<T> values) {
        if (values.size() != 1) {
            throw new IllegalArgumentException("Incorrect collection size " + values.size());
        }
        return values.iterator().next();
    }

    public static <T> List<T> join(Collection<T> first, Collection<T> second) {
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static <T> Set<T> joinToSet(Collection<T> first, Collection<T> second) {
        HashSet<T> list = new HashSet<T>(Math.max(first.size(), second.size()));
        list.addAll(first);
        list.addAll(second);
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... t) {
        return new LinkedHashSet<T>(Arrays.asList(t));
    }
}

