/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;

public class CacheHandler
implements InvocationHandler {
    private final ConcurrentMap<Key, Object> cache = new ConcurrentHashMap<Key, Object>(512);
    private final Object delegate;

    public static <T> T cache(T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), delegate.getClass().getInterfaces(), (InvocationHandler)new CacheHandler(delegate));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        return this.cache.computeIfAbsent(new Key(method, args), key1 -> {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (Exception e) {
                this.handleExceptionCause(e);
                throw new RuntimeException(e);
            }
        });
    }

    private void handleExceptionCause(Exception e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new RuntimeException(cause);
    }

    @ConstructorProperties(value={"delegate"})
    @Generated
    public CacheHandler(Object delegate) {
        this.delegate = delegate;
    }

    private static class Key {
        private final Method method;
        private final List<Object> args;

        private Key(Method method, Object[] args) {
            this.method = method;
            this.args = args != null && args.length > 0 ? Arrays.asList(args) : Collections.emptyList();
        }

        public String toString() {
            return this.method.getName() + " " + this.args;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Method this$method = this.method;
            Method other$method = other.method;
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            List<Object> this$args = this.args;
            List<Object> other$args = other.args;
            return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $method = this.method;
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            List<Object> $args = this.args;
            result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
            return result;
        }
    }
}

