/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.exception.RemoteProcedureCallAlreadyExistsException;
import io.github.microserviceapipatterns.protobufgen.model.Identifiable;
import io.github.microserviceapipatterns.protobufgen.model.Identifier;
import io.github.microserviceapipatterns.protobufgen.model.RemoteProcedureCall;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Service
implements Identifiable {
    private Identifier name;
    private String comment;
    private Set<RemoteProcedureCall> rpcs;

    private Service() {
    }

    public String getName() {
        return this.name.toString();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public Set<RemoteProcedureCall> getRemoteProcedureCalls() {
        return new HashSet<RemoteProcedureCall>(this.rpcs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return this.name.equals(service.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final Identifier name;
        private String comment;
        private final Set<RemoteProcedureCall> rpcs;

        public Builder(String serviceName) {
            this.name = new Identifier(serviceName);
            this.comment = "";
            this.rpcs = new HashSet<RemoteProcedureCall>();
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withRPC(RemoteProcedureCall rpc) {
            if (this.rpcs.stream().anyMatch(c -> c.getName().equals(rpc.getName()))) {
                throw new RemoteProcedureCallAlreadyExistsException(rpc.getName());
            }
            this.rpcs.add(rpc);
            return this;
        }

        public Builder withRPC(RemoteProcedureCall.Builder rpcBuilder) {
            return this.withRPC(rpcBuilder.build());
        }

        public Service build() {
            Service service = new Service();
            service.name = this.name;
            service.comment = this.comment;
            service.rpcs = new HashSet<RemoteProcedureCall>(this.rpcs);
            return service;
        }
    }
}

