/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.model.Identifiable;
import io.github.microserviceapipatterns.protobufgen.model.Identifier;
import io.github.microserviceapipatterns.protobufgen.model.Message;
import java.util.Objects;

public class RemoteProcedureCall
implements Identifiable {
    private Identifier name;
    private Message input;
    private Message output;
    private boolean streamInput;
    private boolean streamOutput;
    private String comment;

    private RemoteProcedureCall() {
    }

    public String getName() {
        return this.name.toString();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    public Message getInput() {
        return this.input;
    }

    public Message getOutput() {
        return this.output;
    }

    public boolean isInputStreamed() {
        return this.streamInput;
    }

    public boolean isOutputStreamed() {
        return this.streamOutput;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteProcedureCall that = (RemoteProcedureCall)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final Identifier name;
        private final Message input;
        private final Message output;
        private boolean inputStreamed = false;
        private boolean outputStreamed = false;
        private String comment;

        public Builder(String name, Message input, Message output) {
            this.name = new Identifier(name);
            this.input = input;
            this.output = output;
            this.comment = "";
        }

        public Builder withInputAsStream() {
            this.inputStreamed = true;
            return this;
        }

        public Builder withOutputAsStream() {
            this.outputStreamed = true;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public RemoteProcedureCall build() {
            RemoteProcedureCall rpc = new RemoteProcedureCall();
            rpc.name = this.name;
            rpc.input = this.input;
            rpc.output = this.output;
            rpc.streamInput = this.inputStreamed;
            rpc.streamOutput = this.outputStreamed;
            rpc.comment = this.comment;
            return rpc;
        }
    }
}

