/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.model.FieldNumber;
import io.github.microserviceapipatterns.protobufgen.model.FieldType;
import io.github.microserviceapipatterns.protobufgen.model.Identifier;
import java.util.Objects;

public class MessageField
implements Comparable<MessageField> {
    private Identifier name;
    private FieldNumber number;
    private String comment;
    private FieldType type;
    private boolean repeated;

    private MessageField() {
    }

    public String getName() {
        return this.name.toString();
    }

    public String getType() {
        return this.type.getName();
    }

    public String getComment() {
        return this.comment;
    }

    public int getNumber() {
        return this.number.toInt();
    }

    public boolean isRepeated() {
        return this.repeated;
    }

    @Override
    public int compareTo(MessageField messageField) {
        return this.number.compareTo(messageField.number);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageField messageField = (MessageField)o;
        return this.name.equals(messageField.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final Identifier name;
        private final FieldNumber number;
        private final FieldType type;
        private String comment;
        private boolean repeated = false;

        public Builder(FieldType type, String fieldName, int fieldNumber) {
            this.name = new Identifier(fieldName);
            this.number = new FieldNumber(fieldNumber);
            this.type = type;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder repeated() {
            this.repeated = true;
            return this;
        }

        public MessageField build() {
            MessageField messageField = new MessageField();
            messageField.name = this.name;
            messageField.comment = this.comment;
            messageField.number = this.number;
            messageField.type = this.type;
            messageField.repeated = this.repeated;
            return messageField;
        }
    }
}

