/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.model.Identifier;
import java.util.Objects;

public class EnumField
implements Comparable<EnumField> {
    private Identifier name;
    private int value;
    private String comment;

    private EnumField() {
    }

    public String getName() {
        return this.name.toString();
    }

    public int getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public int compareTo(EnumField enumField) {
        return Integer.valueOf(this.value).compareTo(enumField.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumField enumField = (EnumField)o;
        return this.name.equals(enumField.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final Identifier name;
        private final int value;
        private String comment;

        public Builder(String name, int value) {
            this.name = new Identifier(name);
            this.value = value;
            this.comment = "";
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public EnumField build() {
            EnumField enumField = new EnumField();
            enumField.name = this.name;
            enumField.value = this.value;
            enumField.comment = this.comment;
            return enumField;
        }
    }
}

