/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.exception.FieldAlreadyExistsException;
import io.github.microserviceapipatterns.protobufgen.exception.FirstEnumFieldZeroValueException;
import io.github.microserviceapipatterns.protobufgen.model.EnumField;
import io.github.microserviceapipatterns.protobufgen.model.FieldType;
import io.github.microserviceapipatterns.protobufgen.model.Identifiable;
import io.github.microserviceapipatterns.protobufgen.model.Identifier;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Enum
implements FieldType,
Identifiable {
    private Identifier name;
    private Set<EnumField> fields;
    private String comment;

    private Enum() {
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    public Set<EnumField> getFields() {
        return new TreeSet<EnumField>(this.fields);
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Enum anEnum = (Enum)o;
        return this.name.equals(anEnum.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final Identifier name;
        private final Set<EnumField> fields;
        private String comment;
        private int valueCounter = 0;

        public Builder(String name) {
            this.name = new Identifier(name);
            this.comment = "";
            this.fields = new TreeSet<EnumField>();
        }

        public Builder withField(EnumField enumField) {
            if (this.fields.isEmpty() && enumField.getValue() != 0) {
                throw new FirstEnumFieldZeroValueException();
            }
            if (this.fields.stream().anyMatch(f -> f.getName().equals(enumField.getName()))) {
                throw new FieldAlreadyExistsException(enumField.getName());
            }
            this.fields.add(enumField);
            this.valueCounter = enumField.getValue() + 1;
            return this;
        }

        public Builder withField(EnumField.Builder enumFieldBuilder) {
            this.withField(enumFieldBuilder.build());
            return this;
        }

        public Builder withField(String fieldName) {
            this.withField(new EnumField.Builder(fieldName, this.valueCounter).build());
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Enum build() {
            Enum enumm = new Enum();
            enumm.name = this.name;
            enumm.comment = this.comment;
            enumm.fields = new TreeSet<EnumField>(this.fields);
            return enumm;
        }
    }
}

