/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper;

public class NamesAreUniqueValidator
extends AbstractDeclarativeValidator {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    @Inject
    private INamesAreUniqueValidationHelper helper;

    @Override
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkUniqueNamesInResourceOf(EObject eObject) {
        Map<Object, Object> context = this.getContext();
        Resource resource = eObject.eResource();
        if (resource == null) {
            return;
        }
        CancelIndicator cancelIndicator = null;
        if (context != null) {
            if (context.containsKey(resource)) {
                return;
            }
            context.put(resource, this);
            cancelIndicator = (CancelIndicator)context.get(CancelableDiagnostician.CANCEL_INDICATOR);
        }
        this.doCheckUniqueNames(resource, cancelIndicator);
    }

    public void doCheckUniqueNames(Resource resource, CancelIndicator cancelIndicator) {
        IResourceDescription description;
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(resource.getURI());
        if (resourceServiceProvider == null) {
            return;
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        if (manager != null && (description = manager.getResourceDescription(resource)) != null) {
            Iterable<IEObjectDescription> descriptions = description.getExportedObjects();
            this.helper.checkUniqueNames(descriptions, cancelIndicator, this);
        }
    }

    public void setHelper(INamesAreUniqueValidationHelper helper) {
        this.helper = helper;
    }

    public INamesAreUniqueValidationHelper getHelper() {
        return this.helper;
    }

    public void setResourceServiceProviderRegistry(IResourceServiceProvider.Registry resourceDescriptionManagerRegistry) {
        this.resourceServiceProviderRegistry = resourceDescriptionManagerRegistry;
    }

    public IResourceServiceProvider.Registry getResourceServiceProviderRegistry() {
        return this.resourceServiceProviderRegistry;
    }
}

