/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.Priority;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PreferenceTaskTagProvider
implements ITaskTagProvider {
    public static final PreferenceKey TAGS_KEY = new PreferenceKey("task.tags", "TODO,FIXME,XXX");
    public static final PreferenceKey PRIORITIES_KEY = new PreferenceKey("task.priorities", "NORMAL,HIGH,NORMAL");
    public static final PreferenceKey CASE_SENSITIVE_KEY = new PreferenceKey("task.caseSensitive", "true");
    public static final List<PreferenceKey> KEYS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new PreferenceKey[]{TAGS_KEY, PRIORITIES_KEY, CASE_SENSITIVE_KEY}));
    private IPreferenceValuesProvider preferenceValuesProvider;

    public static List<TaskTag> parseTags(String names, String priorities) {
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
        List tags = IterableExtensions.toList((Iterable)splitter.split((CharSequence)names));
        List prios = IterableExtensions.toList((Iterable)splitter.split((CharSequence)priorities));
        ArrayList<TaskTag> elements = new ArrayList<TaskTag>();
        for (int i = 0; i < tags.size(); ++i) {
            TaskTag taskTag = new TaskTag();
            taskTag.setName((String)tags.get(i));
            Priority priority = Priority.NORMAL;
            if (prios.size() >= i) {
                try {
                    priority = Priority.valueOf((String)prios.get(i));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            taskTag.setPriority(priority);
            elements.add(taskTag);
        }
        return elements;
    }

    public static String serializeTags(List<TaskTag> tags) {
        return tags.stream().map(t -> t.getName()).collect(Collectors.joining(","));
    }

    public static String serializePriorities(List<TaskTag> tags) {
        return tags.stream().map(t -> t.getPriority().toString()).collect(Collectors.joining(","));
    }

    @Override
    public TaskTags getTaskTags(Resource resource) {
        IPreferenceValues prefs = this.preferenceValuesProvider.getPreferenceValues(resource);
        String names = prefs.getPreference(TAGS_KEY);
        String priorities = prefs.getPreference(PRIORITIES_KEY);
        TaskTags taskTags = new TaskTags();
        taskTags.setCaseSensitive(Boolean.valueOf(prefs.getPreference(CASE_SENSITIVE_KEY)));
        List<TaskTag> tags = PreferenceTaskTagProvider.parseTags(names, priorities);
        taskTags.getTaskTags().addAll(tags);
        return taskTags;
    }

    @Inject
    public void setPreferenceValuesProvider(IPreferenceValuesProvider preferenceValuesProvider) {
        this.preferenceValuesProvider = preferenceValuesProvider;
    }
}

