/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.AsyncEndpoint;
import io.mdsl.apiDescription.ConsumptionWhereClauses;
import io.mdsl.apiDescription.CorrelationIdWhereClause;
import io.mdsl.apiDescription.OASSecurity;
import io.mdsl.validation.AbstractMDSLValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class RuntimeExpressionValidator
extends AbstractMDSLValidator {
    private String runtimeExpressionRegex = "\\\"?\\$message.(header|payload)#\\/[A-Za-z0-9_]*\\\"?";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkCorrelationId(CorrelationIdWhereClause clausole) {
        if (!clausole.getSource().matches(this.runtimeExpressionRegex)) {
            this.error("Incorrect format for the expression. Format is $message.(payload | header)#/<path>.", clausole, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getCorrelationIdWhereClause_Source());
        }
    }

    @Check
    public void checkIfExpression(ConsumptionWhereClauses clausole) {
        if (!clausole.getLeftExp().matches(this.runtimeExpressionRegex)) {
            this.error("Incorrect format for the left expression. Format is $message.(payload | header)#/<path>.", clausole, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getConsumptionWhereClauses_LeftExp());
        }
    }

    @Check
    public void checkAsyncEndpointSecurityPolicyFormat(AsyncEndpoint endpoint) {
        OASSecurity policy = endpoint.getSecurityPolicy();
        if (policy == null) {
            return;
        }
        String policyExpression = endpoint.getSecurityPolicyExpression();
        if (policy.getValue() == 0 && policyExpression != null) {
            this.warning("Expression not needed when using BASIC_AUTHENTICATION.", endpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getAsyncEndpoint_SecurityPolicyExpression());
        }
        if (policy.getValue() == 2) {
            if (policyExpression == null) {
                this.warning("A policy expression is required for API_KEY. Consider to specify where to find the API_KEY in the message. Example: using API_KEY in \"$message.header#/apiKey\"", endpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getAsyncEndpoint_SecurityPolicy());
            } else if (!policyExpression.matches(this.runtimeExpressionRegex)) {
                this.error("Incorrect format for the security policy expression. Format is $message.(payload | header)#/<path>.", endpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getAsyncEndpoint_SecurityPolicyExpression());
            }
        }
    }
}

