/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.CombinedInvocationStep;
import io.mdsl.apiDescription.CommandInvokationStep;
import io.mdsl.apiDescription.DomainEventProductionStep;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Orchestration;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.validation.AbstractMDSLValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class FlowValidator
extends AbstractMDSLValidator {
    public static final String FLOW_WITHOUT_SUPPORTING_ENDPOINT_TYPE_FOUND = "FLOW_WITHOUT_SUPPORTING_ENDPOINT_TYPE_FOUND";
    public static final String FLOW_CIS_STEP_FOUND = "FLOW_CIS_STEP_FOUND";
    public static final String FLOW_DEP_STEP_FOUND = "FLOW_DEP_STEP_FOUND";
    public static final String FLOW_SIMPLE_DEP_STEP_FOUND = "FLOW_SIMPLE_DEP_STEP_FOUND";
    public static final String FLOW_ECE_STEP_FOUND = "FLOW_ECE_STEP_FOUND";
    public static final String COMMAND_FOUND = "COMMAND_FOUND";
    public static final String EVENT_FOUND = "EVENT_FOUND";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void analyzeFlow(Orchestration flow) {
        if (flow.getName() != null) {
            boolean supported = false;
            EList<EObject> endpointContracts = ((ServiceSpecification)flow.eContainer()).getContracts();
            for (EObject contract : endpointContracts) {
                EndpointContract endpointContract;
                if (!(contract instanceof EndpointContract) || (endpointContract = (EndpointContract)contract).getFlow() == null || !endpointContract.getFlow().getName().equals(flow.getName())) continue;
                supported = true;
            }
            if (!supported) {
                this.info("This flow could be supported by an endpoint type.", flow, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOrchestration_Name(), FLOW_WITHOUT_SUPPORTING_ENDPOINT_TYPE_FOUND, new String[0]);
            }
        }
    }

    @Check
    public void analyzeCisStep(CommandInvokationStep cis) {
        if (cis != null && cis.getAction() != null) {
            if (cis.eContainer() instanceof CombinedInvocationStep) {
                return;
            }
            this.info("This command invocation step can be further refined.", cis, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getCommandInvokationStep_Action(), FLOW_CIS_STEP_FOUND, new String[0]);
        }
    }

    @Check
    public void analyzeDepStep(DomainEventProductionStep dep) {
        if (dep != null && dep.getEventProduction() != null) {
            this.info("This domain event emission step can be further refined.", dep, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getDomainEventProductionStep_EventProduction(), FLOW_DEP_STEP_FOUND, new String[0]);
            if (dep.getEventProduction().getSep() != null) {
                this.info("Look for consolidation opportunities.", dep, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getDomainEventProductionStep_Action(), FLOW_SIMPLE_DEP_STEP_FOUND, new String[0]);
            }
        }
    }

    @Check
    public void analyzeEceStep(CombinedInvocationStep ece) {
        if (ece != null && ece.getCisStep() != null && ece.getEventProduction() != null) {
            this.info("This combined invocation step can be split.", ece, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getCombinedInvocationStep_CisStep(), FLOW_ECE_STEP_FOUND, new String[0]);
        }
    }
}

