/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.Provider;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.validation.AbstractMDSLValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class EndpointContractValidator
extends AbstractMDSLValidator {
    public static final String HTTP_RESOURCE_BINDING_MISSING = "HTTP_RESOURCE_BINDING_MISSING";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void reportMissingHTTPBinding(EndpointContract epc) {
        boolean found = false;
        ServiceSpecification ss = (ServiceSpecification)epc.eContainer();
        for (EObject provider : ss.getProviders()) {
            if (!(provider instanceof Provider)) continue;
            EList<EndpointList> epls = ((Provider)provider).getEpl();
            for (EndpointList epl : epls) {
                if (!epl.getContract().getName().equals(epc.getName())) continue;
                for (EndpointInstance ep : epl.getEndpoints()) {
                    EList<TechnologyBinding> pb = ep.getPb();
                    for (TechnologyBinding tb : pb) {
                        if (tb.getProtBinding().getHttp() == null) continue;
                        found = true;
                    }
                }
            }
        }
        if (!found) {
            this.info(epc.getName() + " is not bound to an HTTP provider yet.", epc, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getEndpointContract_Name(), HTTP_RESOURCE_BINDING_MISSING, new String[0]);
        }
    }
}

