/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.Channel;
import io.mdsl.apiDescription.ChannelContract;
import io.mdsl.apiDescription.ChannelPathWithParams;
import io.mdsl.apiDescription.ChannelType;
import io.mdsl.apiDescription.OneWayChannel;
import io.mdsl.apiDescription.RequestReplyChannel;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.validation.AbstractMDSLValidator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ChannelContractValidator
extends AbstractMDSLValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkChannelsPathAreUnique(ServiceSpecification root) {
        HashSet<String> channelPaths = new HashSet<String>();
        List channels = EcoreUtil2.getAllContentsOfType((EObject)root, ChannelPathWithParams.class);
        for (ChannelPathWithParams channel : channels) {
            if (channelPaths.add(channel.getPath())) continue;
            this.error("Duplicate channel path '" + channel.getPath() + "'", channel, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getChannelPathWithParams_Path());
        }
    }

    @Check
    public void checkMessageNamesAreUnique(ServiceSpecification root) {
        HashSet<String> messageNames = new HashSet<String>();
        List channels = EcoreUtil2.getAllContentsOfType((EObject)root, Channel.class);
        for (Channel channel : channels) {
            if (messageNames.add(channel.getName())) continue;
            this.error("Duplicate channel name '" + channel.getName() + "'", channel, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getChannel_Name());
        }
    }

    @Check
    public void checkRequestReplyChannelTypes(ChannelContract channel) {
        if (channel.getConversationType() instanceof RequestReplyChannel) {
            LinkedList<String> notAllowedTypesInRequestReply = new LinkedList<String>();
            notAllowedTypesInRequestReply.add(ChannelType.PUBLISH_SUBSCRIBE.getName());
            notAllowedTypesInRequestReply.add(ChannelType.INVALID_MESSAGE.getName());
            notAllowedTypesInRequestReply.add(ChannelType.DEAD_LETTER.getName());
            this.setValidationErrorForChannelWithType(channel, notAllowedTypesInRequestReply, "REQUEST_REPLY");
        }
    }

    @Check
    public void checkChannelTypes(ChannelContract channel) {
        List channelTypes = channel.getTypes().stream().map(t -> t.getName()).collect(Collectors.toList());
        if (channelTypes.contains(ChannelType.POINT_TO_POINT.getName())) {
            LinkedList<String> notAllowedTypesWithPointToPoint = new LinkedList<String>();
            notAllowedTypesWithPointToPoint.add(ChannelType.PUBLISH_SUBSCRIBE.getName());
            notAllowedTypesWithPointToPoint.add(ChannelType.INVALID_MESSAGE.getName());
            notAllowedTypesWithPointToPoint.add(ChannelType.DEAD_LETTER.getName());
            this.setValidationErrorForChannelWithType(channel, notAllowedTypesWithPointToPoint, ChannelType.POINT_TO_POINT.getName());
        } else if (channelTypes.contains(ChannelType.PUBLISH_SUBSCRIBE.getName())) {
            LinkedList<String> notAllowedTypesWithPublishSubscribe = new LinkedList<String>();
            notAllowedTypesWithPublishSubscribe.add(ChannelType.POINT_TO_POINT.getName());
            notAllowedTypesWithPublishSubscribe.add(ChannelType.INVALID_MESSAGE.getName());
            notAllowedTypesWithPublishSubscribe.add(ChannelType.DEAD_LETTER.getName());
            this.setValidationErrorForChannelWithType(channel, notAllowedTypesWithPublishSubscribe, ChannelType.PUBLISH_SUBSCRIBE.getName());
        } else if (channelTypes.contains(ChannelType.DEAD_LETTER.getName())) {
            LinkedList<String> notAllowedTypesWithDeadLetter = new LinkedList<String>();
            notAllowedTypesWithDeadLetter.add(ChannelType.POINT_TO_POINT.getName());
            notAllowedTypesWithDeadLetter.add(ChannelType.INVALID_MESSAGE.getName());
            notAllowedTypesWithDeadLetter.add(ChannelType.PUBLISH_SUBSCRIBE.getName());
            notAllowedTypesWithDeadLetter.add(ChannelType.DATA_TYPE.getName());
            notAllowedTypesWithDeadLetter.add(ChannelType.GUARANTEED_DELIVERY.getName());
            this.setValidationErrorForChannelWithType(channel, notAllowedTypesWithDeadLetter, ChannelType.DEAD_LETTER.getName());
        } else if (channelTypes.contains(ChannelType.INVALID_MESSAGE.getName())) {
            LinkedList<String> notAllowedTypesWithInvalidMessage = new LinkedList<String>();
            notAllowedTypesWithInvalidMessage.add(ChannelType.POINT_TO_POINT.getName());
            notAllowedTypesWithInvalidMessage.add(ChannelType.DEAD_LETTER.getName());
            notAllowedTypesWithInvalidMessage.add(ChannelType.PUBLISH_SUBSCRIBE.getName());
            notAllowedTypesWithInvalidMessage.add(ChannelType.DATA_TYPE.getName());
            notAllowedTypesWithInvalidMessage.add(ChannelType.GUARANTEED_DELIVERY.getName());
            this.setValidationErrorForChannelWithType(channel, notAllowedTypesWithInvalidMessage, ChannelType.INVALID_MESSAGE.getName());
        }
    }

    private void setValidationErrorForChannelWithType(ChannelContract channel, List<String> notAllowedTypes, String mainType) {
        List channelTypes = channel.getTypes().stream().map(t -> t.getName()).collect(Collectors.toList());
        for (String notAllowedType : notAllowedTypes) {
            if (!channelTypes.contains(notAllowedType)) continue;
            this.error("The '" + mainType + "' Channel '" + channel.getName() + "' can not be also of type '" + notAllowedType + "'. Consider removing this type.", channel, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getChannelContract_Types());
        }
    }

    @Check
    public void checkDuplicateChannelTypes(ChannelContract channel) {
        List channelTypes = channel.getTypes().stream().map(t -> t.getName()).collect(Collectors.toList());
        HashSet<String> channelTypesSet = new HashSet<String>();
        for (String channelType : channelTypes) {
            if (channelTypesSet.add(channelType)) continue;
            this.error("The Channel '" + channel.getName() + "' already has type '" + channelType + "'. Consider removing this duplicate type.", channel, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getChannelContract_Types());
        }
    }

    @Check
    public void checkMissingParamsInOneWayChannelPath(ChannelContract channel) {
        if (channel.getConversationType() instanceof OneWayChannel) {
            String channelName = channel.getName();
            ChannelPathWithParams path = ((OneWayChannel)channel.getConversationType()).getPath();
            this.checkMissingParameterInChannelPathError(channelName, path);
        }
    }

    @Check
    public void checkMissingParamsInRequestReplyChannelPath(RequestReplyChannel channel) {
        this.checkMissingParameterInChannelPathError(channel.getRequest().getName(), channel.getRequest().getPath());
        this.checkMissingParameterInChannelPathError(channel.getReply().getName(), channel.getReply().getPath());
    }

    private void checkMissingParameterInChannelPathError(String channelName, ChannelPathWithParams src) {
        if (src.getPath().contains("${") && (src.getParams() == null || src.getParams().size() == 0)) {
            this.error("The Channel '" + channelName + "' contains parameters in the path. Consider adding the description of those using 'with paramName: type, \"Parameter description\"'", src, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getChannelPathWithParams_Path());
        }
    }

    @Check
    public void checkDeliveryGuaranteeConsistency(ChannelContract channel) {
        EList<ChannelType> channelTypes = channel.getTypes();
        if (channelTypes.stream().anyMatch(t -> t.getValue() == 5)) {
            int deliveryGuarantee = channel.getQuality().getValue();
            if (deliveryGuarantee == 0) {
                this.warning("GUARANTEED_DELIVERY channel '" + channel.getName() + "' should have a delivery guarantee of type AT_LEAST_ONCE or EXACTLY_ONCE.", channel, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getChannelContract_Types(), channelTypes.indexOf((Object)channelTypes.stream().filter(t -> t.getValue() == 5).findFirst().get()));
            } else {
                boolean hasInconsistency;
                boolean bl = hasInconsistency = deliveryGuarantee != 1 && deliveryGuarantee != 3;
                if (hasInconsistency) {
                    this.error("GUARANTEED_DELIVERY channel '" + channel.getName() + "' must have a delivery guarantee of type AT_LEAST_ONCE or EXACTLY_ONCE.", channel, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getChannelContract_Types(), channelTypes.indexOf((Object)channelTypes.stream().filter(t -> t.getValue() == 5).findFirst().get()));
                }
            }
        }
    }
}

