/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.JavaBinding;
import io.mdsl.apiDescription.JavaOperationBinding;
import io.mdsl.apiDescription.ProtocolBinding;
import io.mdsl.apiDescription.Provider;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.validation.AbstractMDSLValidator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class BasicBindingValidator
extends AbstractMDSLValidator {
    private static final String JAVA_BINDING_PACKAGE_REGEX = "^[a-z][a-z0-9_]*(\\.[a-z0-9_]+)*";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void bindingExistenceValidator(ServiceSpecification specRoot) {
        this.info("MDSL API Linter: only checking very few binding-related rules in " + specRoot.getName() + " in current version", specRoot, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getServiceSpecification_Name());
        List providers = specRoot.getProviders().stream().filter(p -> p instanceof Provider).map(p -> (Provider)p).collect(Collectors.toList());
        for (Provider provider : providers) {
            EList<EndpointList> endpointListInProvider = provider.getEpl();
            for (EndpointList endpointList : endpointListInProvider) {
                EList<EndpointInstance> endpoints = endpointList.getEndpoints();
                for (EndpointInstance endpoint : endpoints) {
                    EList<TechnologyBinding> techBindings = endpoint.getPb();
                    for (int i = 0; i < techBindings.size(); ++i) {
                        TechnologyBinding techBinding = (TechnologyBinding)techBindings.get(i);
                        ProtocolBinding protBinding = techBinding.getProtBinding();
                        if (protBinding.getHttp() != null) continue;
                        if (protBinding.getJava() != null) {
                            this.checkJavaBinding(specRoot, provider.getName(), endpoint.getLocation(), protBinding.getJava());
                            continue;
                        }
                        if (protBinding.getGrpc() != null) continue;
                        if (protBinding.getOther() != null) {
                            this.info("Specification includes a provider endpoint binding of other type ", protBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getProtocolBinding_Other());
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown binding type.");
                    }
                }
            }
        }
    }

    private void checkJavaBinding(ServiceSpecification specRoot, String pName, String address, JavaBinding java) {
        if (java.getPackage() != null && !java.getPackage().matches(JAVA_BINDING_PACKAGE_REGEX)) {
            this.error("The string '" + java.getPackage() + "' does not represent a proper Java package name. Please provide a correctly formatted Java package name (like 'io.mdsl.validator').", java, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getJavaBinding_Package());
        }
        EList<JavaOperationBinding> operationBindings = java.getOpsBinding();
    }
}

