/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.CommandType;
import io.mdsl.apiDescription.CommandTypes;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EventType;
import io.mdsl.apiDescription.EventTypes;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.IntegrationScenario;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.transformations.HTTPBindingTransformations;
import io.mdsl.transformations.MAPDecoratorHelpers;
import io.mdsl.utils.MDSLLogger;
import io.mdsl.utils.MDSLSpecificationWrapper;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class TransformationHelpers {
    private static final String DATA_TYPE_ROLE = "D";
    private static final String REQUEST_BODY_IDENTIFIER = "RequestData";
    private static final String RESPONSE_BODY_IDENTIFIER = "Result";

    public static IntegrationScenario findScenarioInSpecifcation(ServiceSpecification ss, String scenarioName) {
        for (IntegrationScenario is : ss.getScenarios()) {
            if (!is.getName().equals(scenarioName)) continue;
            return is;
        }
        return null;
    }

    public static EndpointContract findOrCreateEndpointType(ServiceSpecification ss, String suggestedName) {
        for (EObject eccc : ss.getContracts()) {
            if (!(eccc instanceof EndpointContract) || !((EndpointContract)eccc).getName().equals(suggestedName)) continue;
            return (EndpointContract)eccc;
        }
        return TransformationHelpers.createEndpointType(ss, suggestedName);
    }

    private static EndpointContract createEndpointType(ServiceSpecification ss, String endpointName) {
        EndpointContract ec = ApiDescriptionFactory.eINSTANCE.createEndpointContract();
        ec.setName(endpointName);
        ss.getContracts().add((Object)ec);
        return ec;
    }

    public static EventType findOrCreateUniqueEventType(ServiceSpecification ss, String suggestedName) {
        List eventTypes = EcoreUtil2.eAllOfType((EObject)ss, EventType.class);
        for (EventType event : eventTypes) {
            if (!event.getName().equals(suggestedName)) continue;
            return event;
        }
        EventType de = ApiDescriptionFactory.eINSTANCE.createEventType();
        de.setName(suggestedName);
        EventTypes eventList = ApiDescriptionFactory.eINSTANCE.createEventTypes();
        eventList.getEvents().add((Object)de);
        ss.getEvents().add((Object)eventList);
        return de;
    }

    public static CommandType findOrCreateUniqueCommandType(ServiceSpecification ss, String suggestedName) {
        List commandTypes = EcoreUtil2.eAllOfType((EObject)ss, CommandType.class);
        for (CommandType command : commandTypes) {
            if (!command.getName().equals(suggestedName)) continue;
            return command;
        }
        CommandType ct = ApiDescriptionFactory.eINSTANCE.createCommandType();
        ct.setName(suggestedName);
        CommandTypes cmdTypeList = ApiDescriptionFactory.eINSTANCE.createCommandTypes();
        cmdTypeList.getCommands().add((Object)ct);
        ss.getCommands().add((Object)cmdTypeList);
        return ct;
    }

    public static Operation findOperationInContract(EndpointContract ec, String opName) {
        for (Operation nextOp : ec.getOps()) {
            if (!nextOp.getName().equals(opName)) continue;
            return nextOp;
        }
        return null;
    }

    public static Operation createOperationWithAtomicRequestAndResponse(String name, String requestRole, String requestType, boolean deliversResponse, String responseType) {
        return TransformationHelpers.createOperationWithAtomicParameters(name, requestRole, requestType, deliversResponse, DATA_TYPE_ROLE, responseType);
    }

    public static Operation createOperationWithAtomicParameters(String name, String requestRole, String requestType, boolean deliversResponse, String responseRole, String responseType) {
        Operation newOp = ApiDescriptionFactory.eINSTANCE.createOperation();
        String opName = DataTypeTransformationHelpers.decapitalizeName(name);
        newOp.setName(opName);
        AtomicParameter inP = DataTypeTransformations.createAtomicDataParameter(opName + REQUEST_BODY_IDENTIFIER, requestType);
        inP.getRat().setRole(requestRole);
        DataTransferRepresentation inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        inDtr.setPayload(DataTypeTransformations.wrapAtomicParameterAsElementStructure(inP));
        newOp.setRequestMessage(inDtr);
        if (deliversResponse) {
            DataTransferRepresentation outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            AtomicParameter outP = DataTypeTransformations.createAtomicDataParameter(opName + RESPONSE_BODY_IDENTIFIER, responseType);
            outP.getRat().setRole(responseRole);
            outDtr.setPayload(DataTypeTransformations.wrapAtomicParameterAsElementStructure(outP));
            newOp.setResponseMessage(outDtr);
        }
        return newOp;
    }

    public static Operation createOperationWithAtomicParameterRequest(String opName, AtomicParameter ap) {
        Operation newOp = ApiDescriptionFactory.eINSTANCE.createOperation();
        newOp.setName(opName);
        DataTransferRepresentation outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        outDtr.setPayload(DataTypeTransformations.wrapAtomicParameterAsElementStructure(ap));
        newOp.setRequestMessage(outDtr);
        return newOp;
    }

    public static Operation createOperationWithAtomicParameterResponse(String opName, AtomicParameter ap) {
        Operation newOp = ApiDescriptionFactory.eINSTANCE.createOperation();
        newOp.setName(opName);
        DataTransferRepresentation outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        outDtr.setPayload(DataTypeTransformations.wrapAtomicParameterAsElementStructure(ap));
        newOp.setResponseMessage(outDtr);
        return newOp;
    }

    public static void setAtomicParameterNames(Operation operation, String inp, String outp) {
        try {
            operation.getRequestMessage().getPayload().getNp().getAtomP().getRat().setName(inp);
            operation.getResponseMessage().getPayload().getNp().getAtomP().getRat().setName(outp);
        }
        catch (Exception e) {
            throw new MDSLException("Operation " + operation.getName() + " should expect and deliver a single atomic parameter.");
        }
    }

    public static Operation createOperationWithIDParameterRequestAndTypeReferenceResponse(String name, String inParameterName, TypeReference responseType) {
        Operation newOp = ApiDescriptionFactory.eINSTANCE.createOperation();
        String opName = DataTypeTransformationHelpers.decapitalizeName(name);
        newOp.setName(opName);
        AtomicParameter inP = DataTypeTransformations.createIDParameter(inParameterName);
        DataTransferRepresentation inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        inDtr.setPayload(DataTypeTransformations.wrapAtomicParameterAsElementStructure(inP));
        newOp.setRequestMessage(inDtr);
        DataTransferRepresentation outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        outDtr.setPayload(DataTypeTransformations.wrapTypeReferenceAsElementStructure(responseType));
        newOp.setResponseMessage(outDtr);
        return newOp;
    }

    public static Operation createOperationWithGenericParameters(String opName, String inName, String outName, boolean deliversResponse) {
        Operation newOp = ApiDescriptionFactory.eINSTANCE.createOperation();
        String decapitalizedOpName = DataTypeTransformationHelpers.decapitalizeName(DataTypeTransformationHelpers.replaceSpacesWithUnderscores(opName));
        newOp.setName(decapitalizedOpName);
        GenericParameter inP = DataTypeTransformations.createGenericParameter(DataTypeTransformationHelpers.decapitalizeName(opName) + REQUEST_BODY_IDENTIFIER);
        if (inName != null) {
            inP.setName(inName);
        }
        DataTransferRepresentation inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        inDtr.setPayload(DataTypeTransformations.wrapGenericParameterNodeAsElementStructure(inP));
        newOp.setRequestMessage(inDtr);
        if (deliversResponse) {
            DataTransferRepresentation outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            outDtr.setPayload(DataTypeTransformations.wrapGenericParameterNodeAsElementStructure(DataTypeTransformations.createGenericParameter(DataTypeTransformationHelpers.decapitalizeName(opName) + RESPONSE_BODY_IDENTIFIER)));
            newOp.setResponseMessage(outDtr);
            if (outName != null) {
                newOp.getResponseMessage().getPayload().getNp().getGenP().setName(outName);
            }
        }
        return newOp;
    }

    public static void findAndAdjustHTTPResourceBindingOfOperation(ServiceSpecification mdslSpecRoot, EndpointContract sourceEndpointType, Operation operation, EndpointContract targetEndpointType) {
        MDSLSpecificationWrapper msw = new MDSLSpecificationWrapper(new ServiceSpecificationAdapter(mdslSpecRoot));
        EndpointInstance httpb = msw.findFirstProviderAndHttpBindingFor(sourceEndpointType);
        if (httpb == null) {
            return;
        }
        HTTPOperationBinding opBindingToBeMoved = HTTPBindingTransformations.findFirstOperationBindingInEndpointInstance(operation.getName(), httpb);
        if (opBindingToBeMoved == null) {
            throw new MDSLException("Can't move operation " + operation.getName() + " because no binding for it was found in first HTTP resource.");
        }
        try {
            HTTPResourceBinding currentResource = (HTTPResourceBinding)opBindingToBeMoved.eContainer();
            currentResource.getOpsB().remove((Object)opBindingToBeMoved);
        }
        catch (Exception e) {
            throw new MDSLException("Source HTTP resource/operation binding does not have the expected structure.");
        }
        EndpointInstance httpb2 = msw.findFirstProviderAndHttpBindingFor(targetEndpointType);
        if (httpb2 == null) {
            HTTPBindingTransformations hbts = new HTTPBindingTransformations();
            hbts.addBinding(targetEndpointType);
        } else {
            try {
                ((HTTPResourceBinding)((TechnologyBinding)httpb2.getPb().get(0)).getProtBinding().getHttp().getEb().get(0)).getOpsB().add((Object)opBindingToBeMoved);
            }
            catch (Exception e) {
                throw new MDSLException("Target HTTP resource/operation binding should have at least one HTTP protocol binding with one resource.");
            }
        }
    }

    public static ElementStructure findElementStructureOf(TreeNode node) {
        if (node.getApl() != null) {
            return null;
        }
        if (node.getChildren() != null) {
            return DataTypeTransformations.wrapParameterTreeAsElementStructure(node.getChildren());
        }
        if (node.getPn().getAtomP() != null) {
            return DataTypeTransformations.wrapAtomicParameterAsElementStructure(node.getPn().getAtomP());
        }
        if (node.getPn().getGenP() != null) {
            return DataTypeTransformations.wrapGenericParameterNodeAsElementStructure(node.getPn().getGenP());
        }
        if (node.getPn().getTr() != null) {
            return DataTypeTransformations.wrapTypeReferenceAsElementStructure(node.getPn().getTr());
        }
        return null;
    }

    public static boolean hasOperationOfName(EndpointContract endpointType, Operation opToBeMoved) {
        endpointType.getOps().stream().map(Operation::getName).anyMatch(name -> name.equals(opToBeMoved.getName()));
        return false;
    }

    public static TreeNode findStereotypeInTree(ParameterTree pt, String decorator) {
        if (pt == null) {
            return null;
        }
        if (MAPDecoratorHelpers.isDecoratedWith(pt, decorator)) {
            EObject parent = pt.eContainer();
            if (parent instanceof TreeNode) {
                return (TreeNode)pt.eContainer();
            }
            return null;
        }
        TreeNode firstNode = TransformationHelpers.findStereotypeInTreeNode(pt.getFirst(), decorator);
        if (firstNode != null) {
            return firstNode;
        }
        for (TreeNode tnSibling : pt.getNexttn()) {
            TreeNode childNode = TransformationHelpers.findStereotypeInTreeNode(tnSibling, decorator);
            if (childNode == null) continue;
            return childNode;
        }
        return null;
    }

    public static TreeNode findStereotypeInTreeNode(TreeNode tn, String decorator) {
        if (tn.getApl() != null) {
            if (MAPDecoratorHelpers.isDecoratedWith(tn.getApl(), decorator)) {
                return tn;
            }
        } else if (tn.getPn() != null) {
            if (MAPDecoratorHelpers.isDecoratedWith(tn.getPn(), decorator)) {
                return tn;
            }
        } else {
            if (tn.getChildren() != null) {
                if (MAPDecoratorHelpers.isDecoratedWith(tn.getChildren(), decorator)) {
                    return tn;
                }
                return TransformationHelpers.findStereotypeInTree(tn.getChildren(), decorator);
            }
            throw new MDSLException("Unexpected tree node type.");
        }
        return null;
    }

    public static EventType findOrCreateEventType(ServiceSpecification ss, String suggestedName) {
        boolean alreadyPresent = false;
        EventType result = null;
        for (EventTypes eventTypes : ss.getEvents()) {
            for (EventType eventType : eventTypes.getEvents()) {
                if (!eventType.getName().equals(suggestedName)) continue;
                alreadyPresent = true;
                result = eventType;
                System.err.println("[W] " + suggestedName + " already exists as a domain event, not adding it.");
            }
        }
        if (!alreadyPresent) {
            EventType de = ApiDescriptionFactory.eINSTANCE.createEventType();
            de.setName(suggestedName);
            AtomicParameter flag = DataTypeTransformations.createMetadataParameter("eventDetails", "string");
            de.setContent(DataTypeTransformations.wrapAtomicParameterAsElementStructure(flag));
            EventTypes des = ApiDescriptionFactory.eINSTANCE.createEventTypes();
            des.getEvents().add((Object)de);
            ss.getEvents().add((Object)des);
            return de;
        }
        return result;
    }

    public static String trimRoleName(String identifier) {
        return identifier.replaceAll("\"", "");
    }

    public static String nameOf(ElementStructure es) {
        if (es.getPt() != null) {
            return es.getPt().getName();
        }
        if (es.getNp() != null) {
            return DataTypeTransformationHelpers.nameOf(es.getNp());
        }
        return null;
    }

    public static void reportError(String message) {
        MDSLLogger.reportError(message);
    }

    public static void reportWarning(String message) {
        MDSLLogger.reportWarning(message);
    }
}

