/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.IntegrationScenario;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.transformations.EndpointTransformations;
import io.mdsl.transformations.HTTPBindingTransformations;
import io.mdsl.transformations.MAPDecoratorHelpers;
import io.mdsl.transformations.MessageTransformations;
import io.mdsl.transformations.OperationTransformations;
import io.mdsl.transformations.ScenarioTransformations;
import io.mdsl.transformations.TransformationHelpers;
import io.mdsl.utils.MDSLLogger;

public class TransformationChains {
    public EndpointContract fromStoryToEndpointTypeWithHTTPBinding(ServiceSpecification apiDescription, String scenarioName) {
        IntegrationScenario is = TransformationHelpers.findScenarioInSpecifcation(apiDescription, scenarioName);
        ScenarioTransformations sts = new ScenarioTransformations();
        EndpointContract ec = sts.addEndpointForScenario(is, true);
        MAPDecoratorHelpers.setRole(ec, "PROCESSING_RESOURCE");
        OperationTransformations ots = new OperationTransformations();
        ots.addOperationsForRole(ec);
        HTTPBindingTransformations hbts = new HTTPBindingTransformations();
        hbts.addBinding(ec);
        return ec;
    }

    public void addQosManagement(ServiceSpecification apiDescription, String endpointTypeName) {
        EndpointContract ept = TransformationHelpers.findOrCreateEndpointType(apiDescription, endpointTypeName);
        OperationTransformations ot = new OperationTransformations();
        for (Operation operation : ept.getOps()) {
            if (operation.getReports() == null) {
                ot.completeOperationWithErrorReport(operation);
            }
            if (operation.getPolicies() == null) {
                ot.completeOperationWithSecurityPolicy(operation);
            }
            try {
                if (operation.getRequestMessage().getPayload().getPt() == null) continue;
                MessageTransformations.addContextRepresentation(operation, null);
            }
            catch (Exception e) {
                MDSLLogger.reportWarning("Unexpected/unsupported request payload in " + operation.getName());
            }
        }
    }

    public void improveQueryPerformanceWithPaginationAndWishList(ServiceSpecification apiDescription, String endpointTypeName) {
        EndpointContract ept = TransformationHelpers.findOrCreateEndpointType(apiDescription, endpointTypeName);
        for (Operation operation : ept.getOps()) {
            ElementStructure requestPayload = operation.getRequestMessage().getPayload();
            if (MAPDecoratorHelpers.isRetrievalOperation(operation)) {
                if (requestPayload == null) continue;
                this.hardenAndCompletePayload(requestPayload);
                MessageTransformations.addWishList(operation);
                ElementStructure responsePayload = operation.getResponseMessage().getPayload();
                if (responsePayload == null) continue;
                this.hardenAndCompletePayload(responsePayload);
                MessageTransformations.addPagination(responsePayload, "offsetFromOperation");
                continue;
            }
            MDSLLogger.reportWarning("This composite transformation can only be applied to retrieval operations, not to " + operation.getName() + " in endpoint type " + ept.getName());
        }
    }

    public void improveCommandPerformanceWithRequestBundleAndCQRS(ServiceSpecification apiDescription, String endpointTypeName) {
        EndpointContract ept = TransformationHelpers.findOrCreateEndpointType(apiDescription, endpointTypeName);
        EndpointTransformations ets = new EndpointTransformations();
        ets.separateCommandsFromQueries(ept);
        for (Operation operation : ept.getOps()) {
            ElementStructure responseElement;
            ElementStructure requestElement = operation.getRequestMessage().getPayload();
            if (requestElement != null && !MAPDecoratorHelpers.isRetrievalOperation(operation) && !MAPDecoratorHelpers.isDeleteOperation(operation)) {
                this.hardenAndCompletePayload(requestElement);
                if (requestElement.getPt() != null) {
                    MessageTransformations.addRequestBundle(requestElement, true);
                }
            }
            if ((responseElement = operation.getRequestMessage().getPayload()) == null || MAPDecoratorHelpers.isRetrievalOperation(operation) || MAPDecoratorHelpers.isDeleteOperation(operation)) continue;
            this.hardenAndCompletePayload(responseElement);
            if (requestElement.getPt() == null) continue;
            MessageTransformations.addRequestBundle(responseElement, false);
        }
    }

    private void hardenAndCompletePayload(ElementStructure payload) {
        if (payload.getPt() != null) {
            return;
        }
        if (payload.getNp() != null) {
            if (payload.getNp().getGenP() != null) {
                DataTypeTransformations.convertToStringType(payload.getNp().getGenP());
            }
            if (payload.getNp().getAtomP() != null) {
                MessageTransformations.addParameterTreeWrapper(payload.getNp().getAtomP());
            } else if (payload.getNp().getTr() != null) {
                MessageTransformations.addParameterTreeWrapper(payload.getNp().getTr());
            }
        }
    }

    public void improveCohesionAndCouplingScore(ServiceSpecification apiDescription, String endpointTypeName) {
    }

    public void applyEntireChainToAllScenariosAndStories(ServiceSpecification apiDescription) {
        for (IntegrationScenario scenario : apiDescription.getScenarios()) {
            EndpointContract ec = this.fromStoryToEndpointTypeWithHTTPBinding(apiDescription, scenario.getName());
            this.addQosManagement(apiDescription, ec.getName());
            this.improveQueryPerformanceWithPaginationAndWishList(apiDescription, ec.getName());
            this.improveCommandPerformanceWithRequestBundleAndCQRS(apiDescription, ec.getName());
        }
    }

    public void applyEntireChainToScenariosAndItsStories(IntegrationScenario scenario, String desiredQuality) {
        if (desiredQuality != "performance") {
            MDSLLogger.reportError("Unsupported target quality: " + desiredQuality);
        }
        ServiceSpecification apiDescription = (ServiceSpecification)scenario.eContainer();
        EndpointContract ec = this.fromStoryToEndpointTypeWithHTTPBinding(apiDescription, scenario.getName());
        this.addQosManagement(apiDescription, ec.getName());
        this.improveQueryPerformanceWithPaginationAndWishList(apiDescription, ec.getName());
        this.improveCommandPerformanceWithRequestBundleAndCQRS(apiDescription, ec.getName());
    }
}

