/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.PatternStereotype;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.transformations.MAPDecoratorHelpers;
import io.mdsl.transformations.TransformationHelpers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MessageTransformationHelpers {
    static final String WISH_TEMPLATE = "Wish_Template";
    static final String WISH_LIST = "Wish_List";
    static final String LINKED_INFORMATION_HOLDER = "Linked_Information_Holder";
    static final String EMBEDDED_ENTITY = "Embedded_Entity";
    static final String WRAPPER_SUFFIX = "Wrapper";
    private static final String TEMPLATE_IDENTIFIER = "mockObject";
    private static final String DEFAULT_OUT_AP_NAME = "OutAP";
    private static final String DEFAULT_IN_AP_NAME = "InAP";

    public static DataTransferRepresentation navigateToRequestPayload(DataTransferRepresentation responsePayload) {
        Operation opAsOp;
        EObject operation = responsePayload.eContainer();
        if (!(operation instanceof Operation)) {
            TransformationHelpers.reportError("Add Pagination: error, expected operation");
        }
        if ((opAsOp = (Operation)operation).getResponseMessage() != responsePayload) {
            TransformationHelpers.reportError("Known limitation: Add Pagination can only be applied to response payloads.");
        }
        return opAsOp.getRequestMessage();
    }

    public static SingleParameterNode createLink(String ptName) {
        AtomicParameter lp = DataTypeTransformations.createLinkParameter(ptName);
        lp.setClassifier(MAPDecoratorHelpers.createTypeDecorator(LINKED_INFORMATION_HOLDER));
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setAtomP(lp);
        spn.setGenP(null);
        spn.setTr(null);
        return spn;
    }

    public static String findPName(boolean fromRequest, AtomicParameter ap) {
        String apName = ap.getRat().getName();
        if (apName == null || apName.isEmpty()) {
            apName = fromRequest ? DEFAULT_IN_AP_NAME : DEFAULT_OUT_AP_NAME;
        }
        return apName;
    }

    public static void wrapParameterTreeInTreeNodeOrElementStructure(EObject containingElement, ParameterTree pt) {
        if (containingElement instanceof TreeNode) {
            TreeNode tn = (TreeNode)containingElement;
            tn.setApl(null);
            tn.setPn(null);
            tn.setChildren(pt);
        } else if (containingElement instanceof ElementStructure) {
            ElementStructure es = (ElementStructure)containingElement;
            es.setApl(null);
            es.setNp(null);
            es.setPt(pt);
            es.setPf(null);
        } else {
            TransformationHelpers.reportError("Expected Tree Node or Element Structure, but got instance of " + containingElement.getClass().toString());
        }
    }

    public static ParameterTree createParameterTreeWrapper(ParameterTree toBeWrapped) {
        ParameterTree ptWrapper = ApiDescriptionFactory.eINSTANCE.createParameterTree();
        TreeNode tn = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        tn.setChildren(toBeWrapped);
        String name = toBeWrapped.getName();
        ptWrapper.setName(DataTypeTransformationHelpers.nameForElement(name, WRAPPER_SUFFIX));
        ptWrapper.setFirst(tn);
        return ptWrapper;
    }

    public static ParameterTree createParameterTreeWrapper(SingleParameterNode np) {
        AtomicParameter ap = np.getAtomP();
        if (ap == null) {
            throw new MDSLException("Known limitation: Can only wrap atomic parameters as parameters trees at present.");
        }
        TreeNode tn = DataTypeTransformations.turnAtomicParameterIntoTreeNode(ap);
        ParameterTree pt = ApiDescriptionFactory.eINSTANCE.createParameterTree();
        pt.setClassifier((PatternStereotype)EcoreUtil.copy((EObject)ap.getClassifier()));
        ap.setClassifier(null);
        String name = ap.getRat().getName();
        pt.setName(DataTypeTransformationHelpers.nameForElement(name, WRAPPER_SUFFIX));
        pt.setFirst(tn);
        return pt;
    }

    public static TreeNode findLinkParameterForInformationHolder(Operation op, boolean fromRequest) {
        ElementStructure es = fromRequest ? op.getRequestMessage().getPayload() : op.getResponseMessage().getPayload();
        if (es.getPt() != null) {
            return TransformationHelpers.findStereotypeInTree(es.getPt(), LINKED_INFORMATION_HOLDER);
        }
        if (es.getNp() != null) {
            throw new MDSLException("This refactoring does not support top-level atomic parameters, but parameter trees");
        }
        throw new MDSLException("Unsupported type of payload structure.");
    }

    public static TreeNode findEmbeddedEntity(Operation op, boolean fromRequest) {
        ParameterTree pt = null;
        pt = fromRequest ? op.getRequestMessage().getPayload().getPt() : op.getResponseMessage().getPayload().getPt();
        return TransformationHelpers.findStereotypeInTree(pt, EMBEDDED_ENTITY);
    }

    public static ParameterTree createWishTemplate(ParameterTree responsePT) {
        ParameterTree wishTemplate = (ParameterTree)EcoreUtil.copy((EObject)responsePT);
        wishTemplate.setName(TEMPLATE_IDENTIFIER);
        PatternStereotype mapDecorator = ApiDescriptionFactory.eINSTANCE.createPatternStereotype();
        mapDecorator.setPattern(WISH_TEMPLATE);
        wishTemplate.setClassifier(mapDecorator);
        return wishTemplate;
    }

    public static TreeNode findWishList(ParameterTree pt) {
        if (pt == null) {
            return null;
        }
        TreeNode tn1 = pt.getFirst();
        if (MessageTransformationHelpers.nodeIsAWishList(tn1)) {
            return tn1;
        }
        for (TreeNode tn : pt.getNexttn()) {
            if (!MessageTransformationHelpers.nodeIsAWishList(tn)) continue;
            return tn;
        }
        return null;
    }

    public static boolean nodeIsAWishList(TreeNode tn) {
        if (tn.getPn() == null) {
            return false;
        }
        AtomicParameter potentialWish = tn.getPn().getAtomP();
        return potentialWish != null && potentialWish.getClassifier() != null && WISH_LIST.equals(potentialWish.getClassifier().getPattern());
    }
}

