/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Event;
import io.mdsl.apiDescription.EventType;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.transformations.TransformationHelpers;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EndpointTransformations {
    private static final String ONE_WAY_MEP = "ONE_WAY";
    private static final String GET_PREFIX = "get";
    private static final String EVENT_PROCESSOR_NAME_PREFIX = "receive";
    private static final String EVENT_SUFFIX = "Event";
    private static final String EVENTS_SUFFIX = "Events";
    private static final String COMMANDS_SUFFIX = "Commands";
    private static final String QUERIES_SUFFIX = "Queries";
    private static final String EVENT_QUERY_PARAMETER_NAME = "eventQuery";

    public static void addEventManagementOperations(EndpointContract ec, String eventName) {
        for (Event event : ec.getEvents()) {
            if (!event.getType().getName().equals(eventName)) continue;
            EndpointTransformations.createEventProcessorOperation(ec, event, "EVENT_PROCESSOR");
            EndpointTransformations.createRetrievalOperationsForEvent(ec, event, "RETRIEVAL_OPERATION");
        }
    }

    public static void createEventProcessorOperation(EndpointContract ec, Event event, String type) {
        Operation result = ApiDescriptionFactory.eINSTANCE.createOperation();
        result.setMep(ONE_WAY_MEP);
        OperationResponsibility ov = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        ov.setEp(type);
        result.setResponsibility(ov);
        EventType et = event.getType();
        result.setName(EVENT_PROCESSOR_NAME_PREFIX + et.getName() + EVENT_SUFFIX);
        DataTransferRepresentation inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        if (et != null && et.getContent() != null) {
            inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            inDtr.setPayload((ElementStructure)EcoreUtil.copy((EObject)et.getContent()));
            result.setRequestMessage(inDtr);
        } else {
            GenericParameter gp = DataTypeTransformations.createGenericParameter("event");
            ElementStructure responsePayload = DataTypeTransformations.wrapGenericParameterNodeAsElementStructure(gp);
            inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            inDtr.setPayload(responsePayload);
            result.setRequestMessage(inDtr);
        }
        result.setRequestMessage(inDtr);
        ec.getOps().add((Object)result);
    }

    public static void createRetrievalOperationsForEvent(EndpointContract ec, Event event, String type) {
        Operation result = ApiDescriptionFactory.eINSTANCE.createOperation();
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        or.setRo("RETRIEVAL_OPERATION");
        result.setResponsibility(or);
        EventType et = event.getType();
        result.setName(GET_PREFIX + et.getName() + EVENTS_SUFFIX);
        DataTransferRepresentation outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        if (et != null && et.getContent() != null) {
            outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            ElementStructure responsePayload = (ElementStructure)EcoreUtil.copy((EObject)et.getContent());
            Cardinality setCardinality = ApiDescriptionFactory.eINSTANCE.createCardinality();
            setCardinality.setZeroOrMore("*");
            DataTypeTransformations.setCardinality(responsePayload, setCardinality);
            outDtr.setPayload(responsePayload);
            result.setResponseMessage(outDtr);
        } else {
            GenericParameter gp = DataTypeTransformations.createGenericParameter("eventResponse");
            ElementStructure responsePayload = DataTypeTransformations.wrapGenericParameterNodeAsElementStructure(gp);
            outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            outDtr.setPayload(responsePayload);
            result.setResponseMessage(outDtr);
        }
        result.setResponseMessage(outDtr);
        AtomicParameter eventSelection = DataTypeTransformations.createMetadataParameter(EVENT_QUERY_PARAMETER_NAME, "string");
        DataTransferRepresentation inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        inDtr.setPayload(DataTypeTransformations.wrapAtomicParameterAsElementStructure(eventSelection));
        result.setRequestMessage(inDtr);
        ec.getOps().add((Object)result);
    }

    public EObject separateCommandsFromQueries(EndpointContract ept) {
        boolean hasWriters = false;
        ArrayList<Operation> readers = new ArrayList<Operation>();
        for (Operation op : ept.getOps()) {
            OperationResponsibility opResp = op.getResponsibility();
            if (opResp != null && opResp.getRo() != null) {
                readers.add(op);
                continue;
            }
            hasWriters = true;
        }
        if (!readers.isEmpty() && hasWriters) {
            ept.getOps().removeAll(readers);
            ServiceSpecification ss = (ServiceSpecification)ept.eContainer();
            EndpointContract queryEndpointType = this.addReadModel(ss, ept.getName() + QUERIES_SUFFIX, readers);
            if (ept.getScenario() != null) {
                queryEndpointType.setScenario(ept.getScenario());
            }
            if (ept.getFlow() != null) {
                queryEndpointType.setFlow(ept.getFlow());
            }
            ept.setName(ept.getName() + COMMANDS_SUFFIX);
            for (Operation nextRetrievalOperation : readers) {
                TransformationHelpers.findAndAdjustHTTPResourceBindingOfOperation(ss, ept, nextRetrievalOperation, queryEndpointType);
            }
            return ss;
        }
        return null;
    }

    private EndpointContract addReadModel(ServiceSpecification ss, String newEndpointName, Collection<Operation> readers) {
        EndpointContract readEPT = TransformationHelpers.findOrCreateEndpointType(ss, newEndpointName);
        readEPT.getOps().addAll(readers);
        return readEPT;
    }
}

