/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.TransformationHelpers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DataTypeTransformations {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setCardinality(ElementStructure pl, Cardinality card) {
        if (pl.getPt() != null) {
            pl.getPt().setCard(card);
            return;
        } else if (pl.getApl() != null) {
            pl.getApl().setCard(card);
            return;
        } else {
            if (pl.getNp() != null) {
                SingleParameterNode spn = pl.getNp();
                if (spn.getAtomP() != null) {
                    spn.getAtomP().setCard(card);
                }
                if (spn.getTr() != null) {
                    spn.getTr().setCard(card);
                }
                if (spn.getGenP() == null) return;
            }
            TransformationHelpers.reportWarning("Cannot set cardinality of " + pl.getClass());
        }
    }

    public static DataTransferRepresentation wrapElementStructureInDataTransferRepresentation(ElementStructure es) {
        DataTransferRepresentation result = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        result.setPayload(es);
        return result;
    }

    public static ElementStructure wrapParameterTreeAsElementStructure(ParameterTree pt) {
        ElementStructure es = ApiDescriptionFactory.eINSTANCE.createElementStructure();
        es.setPt(pt);
        return es;
    }

    public static ElementStructure wrapGenericParameterNodeAsElementStructure(GenericParameter genP) {
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setGenP(genP);
        ElementStructure es = ApiDescriptionFactory.eINSTANCE.createElementStructure();
        es.setNp(spn);
        return es;
    }

    public static ElementStructure wrapTypeReferenceAsElementStructure(TypeReference tref) {
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setTr(tref);
        ElementStructure es = ApiDescriptionFactory.eINSTANCE.createElementStructure();
        es.setNp(spn);
        return es;
    }

    public static TreeNode wrapTypeReferenceAsTreeNode(TypeReference tref) {
        TreeNode result = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setTr(tref);
        result.setPn(spn);
        return result;
    }

    public static ElementStructure wrapAtomicParameterAsElementStructure(AtomicParameter ap) {
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setAtomP(ap);
        ElementStructure es = ApiDescriptionFactory.eINSTANCE.createElementStructure();
        es.setNp(spn);
        return es;
    }

    public static TreeNode wrapAtomicParameterAsTreeNode(AtomicParameter ap) {
        TreeNode result = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setAtomP(ap);
        result.setPn(spn);
        return result;
    }

    public static GenericParameter createGenericParameter(String name) {
        GenericParameter genP = ApiDescriptionFactory.eINSTANCE.createGenericParameter();
        genP.setName(name);
        return genP;
    }

    public static AtomicParameter createAtomicDataParameter(String name, String dataType) {
        return DataTypeTransformations.createAtomicDataParameter(name, "D", dataType);
    }

    public static AtomicParameter createAtomicDataParameter(String name, String role, String dataType) {
        RoleAndType newRaT = ApiDescriptionFactory.eINSTANCE.createRoleAndType();
        newRaT.setName(name);
        newRaT.setRole(role);
        if (!DataTypeTransformationHelpers.isValidTypeRole(role)) {
            TransformationHelpers.reportError("Can't use " + dataType + " as type of " + name + ": not a valid base type role.");
        } else {
            newRaT.setRole(role);
        }
        if (!DataTypeTransformationHelpers.isValidBaseType(dataType)) {
            TransformationHelpers.reportError("Can't use " + dataType + " as type of " + name + ": not a valid MDSL base type.");
        } else {
            newRaT.setBtype(dataType);
        }
        AtomicParameter ap = ApiDescriptionFactory.eINSTANCE.createAtomicParameter();
        ap.setRat(newRaT);
        return ap;
    }

    public static AtomicParameter createMetadataParameter(String name, String dataType) {
        if (!DataTypeTransformationHelpers.isValidBaseType(dataType)) {
            TransformationHelpers.reportError("Can't use " + dataType + " as type of " + name + ": not a valid MDSL base type.");
        }
        RoleAndType newRaT = ApiDescriptionFactory.eINSTANCE.createRoleAndType();
        newRaT.setName(name);
        newRaT.setRole("MD");
        newRaT.setBtype(dataType);
        AtomicParameter ap = ApiDescriptionFactory.eINSTANCE.createAtomicParameter();
        ap.setRat(newRaT);
        return ap;
    }

    public static AtomicParameter createIDParameter(String name) {
        AtomicParameter ap = ApiDescriptionFactory.eINSTANCE.createAtomicParameter();
        RoleAndType rat = ApiDescriptionFactory.eINSTANCE.createRoleAndType();
        if (name != null) {
            rat.setName(name);
        }
        rat.setRole("ID");
        rat.setBtype("int");
        ap.setRat(rat);
        return ap;
    }

    public static AtomicParameter createLinkParameter(String name) {
        RoleAndType newRaT = ApiDescriptionFactory.eINSTANCE.createRoleAndType();
        newRaT.setName(name);
        newRaT.setRole("L");
        newRaT.setBtype("string");
        AtomicParameter ap = ApiDescriptionFactory.eINSTANCE.createAtomicParameter();
        ap.setRat(newRaT);
        return ap;
    }

    public static TreeNode turnAtomicParameterIntoTreeNode(AtomicParameter ap) {
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setAtomP((AtomicParameter)EcoreUtil.copy((EObject)ap));
        TreeNode tn = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        tn.setPn(spn);
        return tn;
    }

    public static TreeNode turnTypeReferenceIntoTreeNode(TypeReference tr) {
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setTr((TypeReference)EcoreUtil.copy((EObject)tr));
        TreeNode tn = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        tn.setPn(spn);
        return tn;
    }

    public static RoleAndType createRoleAndType(String name, String role, String type) {
        RoleAndType rat = ApiDescriptionFactory.eINSTANCE.createRoleAndType();
        rat.setName(name);
        rat.setRole(role);
        rat.setBtype(type);
        return rat;
    }

    public static TypeReference createTypeReference(DataContract dt) {
        TypeReference tr = ApiDescriptionFactory.eINSTANCE.createTypeReference();
        tr.setDcref(dt);
        return tr;
    }

    public static DataContract findOrCreateDataType(ServiceSpecification ss, String typeName, ElementStructure es) {
        for (DataContract dc : ss.getTypes()) {
            if (!dc.getName().equals(typeName + "DTO")) continue;
            return dc;
        }
        DataContract dc = ApiDescriptionFactory.eINSTANCE.createDataContract();
        dc.setName(typeName + "DTO");
        dc.setStructure(es);
        ss.getTypes().add((Object)dc);
        return dc;
    }

    public static DataContract findOrCreateDataTypeByIdentifier(ServiceSpecification ss, String typeIdentifier, ElementStructure es) {
        for (DataContract dc : ss.getTypes()) {
            if (dc.getStructure() == null || TransformationHelpers.nameOf(dc.getStructure()) == null || !TransformationHelpers.nameOf(dc.getStructure()).equals(typeIdentifier)) continue;
            return dc;
        }
        DataContract dc = ApiDescriptionFactory.eINSTANCE.createDataContract();
        dc.setName(DataTypeTransformationHelpers.capitalizeName(typeIdentifier) + "DTO");
        dc.setStructure(es);
        ss.getTypes().add((Object)dc);
        return dc;
    }

    public static DataTransferRepresentation createDTRFromTypeReference(TypeReference typeRef) {
        DataTransferRepresentation dtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setTr(typeRef);
        ElementStructure es = ApiDescriptionFactory.eINSTANCE.createElementStructure();
        es.setNp(spn);
        dtr.setPayload(es);
        return dtr;
    }

    public static void convertToStringType(GenericParameter gp) {
        String gpn = gp.getName();
        if (gpn == null || gpn.isEmpty()) {
            gpn = "anonymous";
        }
        RoleAndType newRaT = ApiDescriptionFactory.eINSTANCE.createRoleAndType();
        newRaT.setName(gpn);
        newRaT.setRole("D");
        newRaT.setBtype("string");
        AtomicParameter newAP = ApiDescriptionFactory.eINSTANCE.createAtomicParameter();
        newAP.setRat(newRaT);
        SingleParameterNode spn = (SingleParameterNode)gp.eContainer();
        spn.setGenP(null);
        spn.setAtomP(newAP);
    }

    public static void completeDataType(RoleAndType rat, String type) {
        rat.setBtype(type);
    }

    public static void convertInlineTypeToTypeReference(DataTransferRepresentation dtr, String typeName) {
        ServiceSpecification ss = (ServiceSpecification)dtr.eContainer().eContainer().eContainer();
        DataContract dt = ApiDescriptionFactory.eINSTANCE.createDataContract();
        dt.setName(DataTypeTransformationHelpers.capitalizeName(typeName));
        dt.setStructure((ElementStructure)EcoreUtil.copy((EObject)dtr.getPayload()));
        boolean typeCouldBeAdded = DataTypeTransformationHelpers.addIfNotPresent(ss, dt);
        if (typeCouldBeAdded) {
            TypeReference tr = ApiDescriptionFactory.eINSTANCE.createTypeReference();
            tr.setName(typeName);
            tr.setDcref(dt);
            SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
            spn.setTr(tr);
            ElementStructure es2 = ApiDescriptionFactory.eINSTANCE.createElementStructure();
            es2.setNp(spn);
            dtr.setPayload(es2);
        } else {
            TransformationHelpers.reportError("A data type with the name " + typeName + " already exists. Cannot perform the refactoring.");
        }
    }

    public static String getParameterName(ElementStructure es) {
        if (es.getNp() != null) {
            if (es.getNp().getAtomP() != null) {
                if (es.getNp().getAtomP().getRat().getName() != null) {
                    return "AnonymousTypeReference";
                }
                return es.getNp().getAtomP().getRat().getName();
            }
            if (es.getNp().getGenP() != null) {
                es.getNp().getGenP().getName();
            } else if (es.getNp().getTr() != null) {
                es.getNp().getTr().getName();
            } else {
                TransformationHelpers.reportError("Can't find name of this parameter type.");
            }
        } else {
            if (es.getPt() != null) {
                return es.getPt().getName();
            }
            TransformationHelpers.reportError("Unsupported type of element structure.");
        }
        return "AnonymousTypeReference";
    }
}

