/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.standalone;

import io.mdsl.APIDescriptionStandaloneSetup;
import io.mdsl.MDSLResource;
import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.standalone.FileSystemHelper;
import io.mdsl.standalone.MDSLStandaloneAPI;
import java.io.File;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;

public class MDSLStandaloneUsageHelper
implements MDSLStandaloneAPI {
    public MDSLStandaloneUsageHelper() {
        APIDescriptionStandaloneSetup.doSetup();
    }

    @Override
    public MDSLResource loadMDSL(String filepath) {
        return new MDSLResource(new ResourceSetImpl().getResource(URI.createURI((String)filepath), true));
    }

    @Override
    public MDSLResource loadMDSL(File mdslFile) {
        return new MDSLResource(new ResourceSetImpl().getResource(URI.createFileURI((String)mdslFile.getAbsolutePath()), true));
    }

    @Override
    public MDSLResource createMDSL(String filepath) {
        return this.createNewMDSLResource(new File(filepath));
    }

    @Override
    public MDSLResource createMDSL(File mdslFile) {
        return this.createNewMDSLResource(mdslFile);
    }

    @Override
    public void callGenerator(MDSLResource mdsl, IGenerator2 generator) {
        generator.doGenerate((Resource)mdsl, (IFileSystemAccess2)FileSystemHelper.getFileSystemAccess(), (IGeneratorContext)new GeneratorContext());
    }

    @Override
    public void callGenerator(MDSLResource mdsl, IGenerator2 generator, String outputDir) {
        generator.doGenerate((Resource)mdsl, (IFileSystemAccess2)FileSystemHelper.getFileSystemAccess(outputDir), (IGeneratorContext)new GeneratorContext());
    }

    private MDSLResource createNewMDSLResource(File file) {
        Resource resource = new ResourceSetImpl().createResource(URI.createFileURI((String)file.getAbsolutePath()));
        resource.getContents().add((Object)ApiDescriptionFactory.eINSTANCE.createServiceSpecification());
        return new MDSLResource(resource);
    }

    @Override
    public String callGeneratorInMemory(MDSLResource mdsl, IGenerator2 generator) {
        String result = "n/a";
        InMemoryFileSystemAccess imfsa = new InMemoryFileSystemAccess();
        generator.doGenerate((Resource)mdsl, (IFileSystemAccess2)imfsa, (IGeneratorContext)new GeneratorContext());
        Map genFiles = imfsa.getAllFiles();
        for (Map.Entry entry : genFiles.entrySet()) {
            if (!((String)entry.getKey()).contains("DEFAULT_OUT")) continue;
            result = (String)entry.getValue();
        }
        return result;
    }
}

