/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.MessageTransformations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class ExtractInformationHolderRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint = "TestName";
    private String sourceOperation = "testOp";

    public ExtractInformationHolderRefactoring(String sourceEndpoint, String sourceOperation) {
        this.sourceEndpoint = sourceEndpoint;
        this.sourceOperation = sourceOperation;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            for (Operation operation : endpoint.getOps()) {
                if (!operation.getName().equals(this.sourceOperation)) continue;
                ElementStructure es = RefactoringHelpers.getRequestPayload(operation);
                MessageTransformations.extractInformationHolder(operation, true);
                String result = "// Interface refactoring 'Extract Information Holder' applied.\n";
                RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, es, result);
                return;
            }
        }
        System.err.println("[W] Endpoint " + this.sourceEndpoint + " and/or operation " + this.sourceOperation + " not found in input file.");
    }
}

