/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.MessageTransformations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class AddRequestBundleRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint = "n/a";
    private String sourceOperation = "n/a";
    boolean applyToRequest = true;
    boolean applyToResponse = false;

    public AddRequestBundleRefactoring(String sourceEndpoint, String sourceOperation, boolean request, boolean response) {
        this.sourceEndpoint = sourceEndpoint;
        this.sourceOperation = sourceOperation;
        this.applyToRequest = request;
        this.applyToResponse = response;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            for (Operation operation : endpoint.getOps()) {
                if (!operation.getName().equals(this.sourceOperation)) continue;
                this.applyRefactorings(mdslSpecification, fsa, inputFileURI, operation);
                return;
            }
        }
        System.err.println("[W] Endpoint " + this.sourceEndpoint + " and/or operation " + this.sourceOperation + " not found in input file.");
    }

    private void applyRefactorings(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI, Operation operation) {
        ElementStructure es;
        if (this.applyToRequest) {
            es = RefactoringHelpers.getRequestPayload(operation);
            if (es != null) {
                this.applyRefactoring(mdslSpecification, fsa, inputFileURI, es, true);
            } else {
                System.err.println("Element structure is null, cannot apply refactoring to request");
            }
        }
        if (this.applyToResponse) {
            es = RefactoringHelpers.getResponsePayload(operation);
            if (es != null) {
                this.applyRefactoring(mdslSpecification, fsa, inputFileURI, es, false);
            } else {
                System.err.println("Element structure is null, cannot apply refactoring to response");
            }
        }
    }

    private void applyRefactoring(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI, ElementStructure es, boolean applyToRequest) {
        es = MessageTransformations.addRequestBundle(es, applyToRequest);
        String result = "// Interface refactoring 'BundleRequests' applied.\n";
        RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, es, result);
    }
}

