/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.MAPDecoratorHelpers;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class AddMAPRoleRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint = null;
    private String roleDecorator = "PROCESSING_RESOURCE";

    public AddMAPRoleRefactoring(String sourceEndpoint, String roleDecorator) {
        this.sourceEndpoint = sourceEndpoint;
        if (roleDecorator != null) {
            this.roleDecorator = roleDecorator;
        }
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            String result = "// Interface refactoring 'Add MAP Decorator' applied.\n";
            if (this.roleDecorator.equals("PROCESSING_RESOURCE")) {
                MAPDecoratorHelpers.setRoleToProcessingResource(endpoint);
            } else if (this.roleDecorator.equals("INFORMATION_HOLDER_RESOURCE")) {
                MAPDecoratorHelpers.setRoleToInformationHolderResource(endpoint);
            } else if (this.roleDecorator.equals("COLLECTION_RESOURCE")) {
                MAPDecoratorHelpers.setRoleToCollectionResource(endpoint);
            } else {
                System.err.println("MAP role decorator " + this.roleDecorator + " is not supported yet.");
            }
            RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, endpoint, result);
            return;
        }
        System.err.println("Endpoint and/or operation not found in input file.");
    }
}

