/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.HTTPBindingTransformations;
import io.mdsl.utils.MDSLLogger;
import io.mdsl.utils.MDSLSpecificationWrapper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class AddHttpResourceDuringBindingSplitRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint = "TestName";
    private String sourceOperation = "testOp";

    public AddHttpResourceDuringBindingSplitRefactoring(String sourceEndpoint, String sourceOperation) {
        this.sourceEndpoint = sourceEndpoint;
        this.sourceOperation = sourceOperation;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            for (Operation operation : endpoint.getOps()) {
                if (!operation.getName().equals(this.sourceOperation)) continue;
                MDSLSpecificationWrapper mdslHelper = new MDSLSpecificationWrapper(new ServiceSpecificationAdapter(mdslSpecification));
                EndpointInstance httpb = mdslHelper.findFirstProviderAndHttpBindingFor(endpoint);
                HTTPResourceBinding binding = RefactoringHelpers.getFirstOnlyResourceBinding(httpb);
                HTTPBindingTransformations hbt = new HTTPBindingTransformations();
                hbt.addHttpResourceDuringBindingSplit(binding);
                String result = "// Interface refactoring 'AddHttpResourceDuringBindingSplit' applied.\n";
                RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, endpoint, result);
                return;
            }
        }
        MDSLLogger.reportWarning("Endpoint " + this.sourceEndpoint + " and/or operation " + this.sourceOperation + " not found in input file.");
    }
}

