/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.EndpointTransformations;
import io.mdsl.transformations.TransformationHelpers;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class AddEventManagementRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint = "TestName";
    private String event = "testEvent";

    public AddEventManagementRefactoring(String sourceEndpoint, String eventName) {
        this.sourceEndpoint = sourceEndpoint;
        this.event = eventName;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            EndpointTransformations.addEventManagementOperations(endpoint, this.event);
            String result = "// Interface refactoring 'Add Event Management' applied.\n";
            RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, endpoint, result);
            return;
        }
        TransformationHelpers.reportWarning("Endpoint " + this.sourceEndpoint + " and/or event " + this.event + " not found in input.");
    }
}

