/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.IntegrationScenario;
import io.mdsl.apiDescription.IntegrationStory;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.ScenarioTransformations;
import io.mdsl.transformations.TransformationHelpers;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class AddEndpointForScenarioRefactoring
extends AbstractMDSLGenerator {
    private String scenarioName;
    private String storyName;

    public AddEndpointForScenarioRefactoring(String scenarioName, String storyName) {
        this.scenarioName = scenarioName;
        this.storyName = storyName;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (IntegrationScenario scenario : new ServiceSpecificationAdapter(mdslSpecification).getScenarios()) {
            if (!scenario.getName().equals(this.scenarioName)) continue;
            for (IntegrationStory story : scenario.getStories()) {
                if (!story.getName().equals(this.storyName)) continue;
                ScenarioTransformations s2et = new ScenarioTransformations();
                s2et.addEndpointForScenario(scenario, true);
                String result = "// Interface refactoring 'AddEndpointForScenario' applied.\n";
                RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, story, result);
                return;
            }
        }
        TransformationHelpers.reportWarning("Scenario " + this.scenarioName + " with story " + this.storyName + " not found");
    }
}

