/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.protobuf.converter;

import io.github.microserviceapipatterns.protobufgen.model.FieldType;
import io.github.microserviceapipatterns.protobufgen.model.Message;
import io.github.microserviceapipatterns.protobufgen.model.MessageField;
import io.github.microserviceapipatterns.protobufgen.model.ProtoSpec;
import io.github.microserviceapipatterns.protobufgen.model.RemoteProcedureCall;
import io.github.microserviceapipatterns.protobufgen.model.Service;
import io.github.microserviceapipatterns.protobufgen.model.SimpleFieldType;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.generator.CardinalityHelper;
import io.mdsl.generator.protobuf.converter.DataType2MessageConverter;
import java.util.Optional;

public class Endpoint2ServiceConverter {
    private ProtoSpec.Builder protoSpec;
    private DataType2MessageConverter dataTypeConverter;

    public Endpoint2ServiceConverter(ProtoSpec.Builder protoSpec, DataType2MessageConverter dataTypeConverter) {
        this.protoSpec = protoSpec;
        this.dataTypeConverter = dataTypeConverter;
    }

    public Service convert(EndpointContract endpoint) {
        Service.Builder service = new Service.Builder(endpoint.getName());
        for (Operation operation : endpoint.getOps()) {
            service.withRPC(this.convertOperation(operation));
        }
        return service.build();
    }

    private RemoteProcedureCall convertOperation(Operation operation) {
        ElementStructure payload;
        TypeReference ref;
        Message input = null;
        Message output = null;
        if (operation.getRequestMessage() != null) {
            if (operation.getRequestMessage().getPayload().getNp() != null && operation.getRequestMessage().getPayload().getNp().getTr() != null) {
                ref = operation.getRequestMessage().getPayload().getNp().getTr();
                input = this.wrapMessageIntoListTypeIfNecessary(this.getExistingMessageOrCreateEmpty(ref.getDcref().getName()), ref.getCard());
            } else {
                payload = operation.getRequestMessage().getPayload();
                input = this.wrapMessageIntoListTypeIfNecessary(this.createNewMessage(operation.getName() + "RequestMessage", payload), this.getCardinality4ElementStructure(payload));
            }
        }
        if (operation.getResponseMessage() != null) {
            if (operation.getResponseMessage().getPayload().getNp() != null && operation.getResponseMessage().getPayload().getNp().getTr() != null) {
                ref = operation.getResponseMessage().getPayload().getNp().getTr();
                output = this.wrapMessageIntoListTypeIfNecessary(this.getExistingMessageOrCreateEmpty(ref.getDcref().getName()), ref.getCard());
            } else {
                payload = operation.getResponseMessage().getPayload();
                output = this.wrapMessageIntoListTypeIfNecessary(this.createNewMessage(operation.getName().substring(0, 1).toUpperCase() + operation.getName().substring(1) + "ResponseMessage", payload), this.getCardinality4ElementStructure(payload));
            }
        }
        if (input == null) {
            input = this.getExistingMessageOrCreateEmpty(operation.getName().substring(0, 1).toUpperCase() + operation.getName().substring(1) + "RequestMessage");
        }
        if (output == null) {
            output = this.getExistingMessageOrCreateEmpty("VoidResponseMessage");
        }
        return new RemoteProcedureCall.Builder(operation.getName(), input, output).build();
    }

    private Message getExistingMessageOrCreateEmpty(String name) {
        Optional<Message> optMessage = this.protoSpec.build().getMessages().stream().filter(m -> m.getName().equals(name)).findFirst();
        if (optMessage.isPresent()) {
            return optMessage.get();
        }
        Message.Builder message = new Message.Builder(name);
        this.protoSpec.withMessage(message);
        return message.build();
    }

    private Message createNewMessage(String name, ElementStructure elementStructure) {
        Message.Builder message = new Message.Builder(name);
        this.dataTypeConverter.mapElementStructure(elementStructure, message);
        this.protoSpec.withMessage(message);
        return message.build();
    }

    private Message wrapMessageIntoListTypeIfNecessary(Message message, Cardinality card) {
        if (CardinalityHelper.isList(card)) {
            Optional<Message> alreadyExistingList = this.getMessageIfAlreadyExists(message.getSimpleName() + "List");
            if (alreadyExistingList.isPresent()) {
                return alreadyExistingList.get();
            }
            Message.Builder wrapper = new Message.Builder(message.getSimpleName() + "List");
            wrapper.withField(new MessageField.Builder((FieldType)message, "entries", 1).repeated().build());
            this.protoSpec.withMessage(wrapper);
            return wrapper.build();
        }
        if (CardinalityHelper.isOptional(card)) {
            Optional<Message> alreadyExistingOptionalType = this.getMessageIfAlreadyExists(message.getSimpleName() + "Optional");
            if (alreadyExistingOptionalType.isPresent()) {
                return alreadyExistingOptionalType.get();
            }
            Message.Builder wrapper = new Message.Builder(message.getSimpleName() + "Optional");
            wrapper.withField(new MessageField.Builder((FieldType)message, "value", 2).build());
            wrapper.withField(new MessageField.Builder((FieldType)SimpleFieldType.BOOL, "has_value", 1).build());
            this.protoSpec.withMessage(wrapper);
            return wrapper.build();
        }
        return message;
    }

    private Optional<Message> getMessageIfAlreadyExists(String name) {
        return this.protoSpec.build().getMessages().stream().filter(m -> m.getName().equals(name)).findFirst();
    }

    private Cardinality getCardinality4ElementStructure(ElementStructure elementStructure) {
        if (elementStructure.getPt() != null) {
            return elementStructure.getPt().getCard();
        }
        if (elementStructure.getApl() != null) {
            return elementStructure.getApl().getCard();
        }
        if (elementStructure.getNp() != null) {
            if (elementStructure.getNp().getAtomP() != null) {
                return elementStructure.getNp().getAtomP().getCard();
            }
            if (elementStructure.getNp().getTr() != null) {
                return elementStructure.getNp().getTr().getCard();
            }
        }
        return null;
    }
}

