/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.converter;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.generator.AnonymousFieldNameGenerator;
import io.mdsl.generator.CardinalityHelper;
import io.mdsl.generator.model.BasicType;
import io.mdsl.generator.model.DataType;
import io.mdsl.generator.model.DataTypeField;
import io.mdsl.generator.model.MDSLGeneratorModel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;

public class DataTypeConverter {
    private AnonymousFieldNameGenerator fieldNameGenerator;
    private MDSLGeneratorModel model;

    public DataTypeConverter(MDSLGeneratorModel model) {
        this.model = model;
        this.fieldNameGenerator = new AnonymousFieldNameGenerator();
    }

    public DataType convert(DataContract dataContract) {
        DataType dataType = new DataType(dataContract.getName());
        this.mapElementStructure(dataContract.getStructure(), dataType);
        return dataType;
    }

    public void mapElementStructure(ElementStructure elementStructure, DataType dataType) {
        if (elementStructure.getPf() != null) {
            this.mapParameterForest(elementStructure.getPf(), dataType);
        } else if (elementStructure.getPt() != null) {
            this.mapParameterTree(elementStructure.getPt(), dataType);
        } else if (elementStructure.getApl() != null) {
            this.mapAtomicParameterList(elementStructure.getApl(), dataType);
        } else {
            this.mapSingleParameterNode(elementStructure.getNp(), dataType);
        }
    }

    private void mapParameterForest(ParameterForest pf, DataType dataType) {
        LinkedList trees = Lists.newLinkedList();
        trees.add(pf.getPtl().getFirst());
        trees.addAll(pf.getPtl().getNext());
        for (ParameterTree tree : trees) {
            String attrName = this.fieldNameGenerator.getUniqueName(tree.getName());
            String typeName = this.getUniqueTypeName(attrName);
            DataType nestedType = new DataType(typeName);
            this.mapParameterTree(tree, nestedType);
            this.model.addDataType(nestedType);
            DataTypeField field = new DataTypeField(attrName);
            field.setType(nestedType);
            field.isList(CardinalityHelper.isList(tree.getCard()));
            field.isNullable(CardinalityHelper.isOptional(tree.getCard()));
            dataType.addField(field);
        }
    }

    private void mapParameterTree(ParameterTree pt, DataType dataType) {
        LinkedList treeNodes = Lists.newLinkedList();
        treeNodes.add(pt.getFirst());
        treeNodes.addAll(pt.getNexttn());
        for (TreeNode treeNode : treeNodes) {
            this.mapTreeNode(treeNode, dataType);
        }
    }

    private void mapTreeNode(TreeNode treeNode, DataType dataType) {
        if (treeNode.getPn() != null && treeNode.getPn().getGenP() != null) {
            DataTypeField field = new DataTypeField(this.fieldNameGenerator.getUniqueName(treeNode.getPn().getGenP().getName()));
            field.setType(BasicType.VOID);
            field.isList(false);
            field.isNullable(false);
            dataType.addField(field);
        } else if (treeNode.getPn() != null) {
            this.mapSingleParameterNode(treeNode.getPn(), dataType);
        } else if (treeNode.getApl() != null) {
            AtomicParameterList list = treeNode.getApl();
            String attrName = this.fieldNameGenerator.getUniqueName(list.getName());
            DataType nestedDataType = new DataType(this.getUniqueTypeName(attrName));
            this.mapAtomicParameterList(list, nestedDataType);
            this.model.addDataType(nestedDataType);
            DataTypeField field = new DataTypeField(attrName);
            field.setType(nestedDataType);
            field.isList(CardinalityHelper.isList(list.getCard()));
            field.isNullable(CardinalityHelper.isOptional(list.getCard()));
            dataType.addField(field);
        } else if (treeNode.getChildren() != null) {
            ParameterTree subTree = treeNode.getChildren();
            String attrName = this.fieldNameGenerator.getUniqueName(subTree.getName());
            DataType nestedDataType = new DataType(this.getUniqueTypeName(attrName));
            this.mapParameterTree(subTree, nestedDataType);
            this.model.addDataType(nestedDataType);
            DataTypeField field = new DataTypeField(attrName);
            field.setType(nestedDataType);
            field.isList(CardinalityHelper.isList(subTree.getCard()));
            field.isNullable(CardinalityHelper.isOptional(subTree.getCard()));
            dataType.addField(field);
        }
    }

    private void mapAtomicParameterList(AtomicParameterList apl, DataType dataType) {
        LinkedList<AtomicParameter> parameters = new LinkedList<AtomicParameter>();
        parameters.add(apl.getFirst());
        parameters.addAll((Collection<AtomicParameter>)apl.getNextap());
        for (AtomicParameter ap : parameters) {
            DataTypeField field = new DataTypeField(this.fieldNameGenerator.getUniqueName(ap.getRat().getName()));
            field.setType(BasicType.byName(ap.getRat().getBtype()));
            field.isList(CardinalityHelper.isList(ap.getCard()));
            field.isNullable(CardinalityHelper.isOptional(ap.getCard()));
            dataType.addField(field);
        }
    }

    private void mapSingleParameterNode(SingleParameterNode spn, DataType dataType) {
        if (spn.getAtomP() != null) {
            DataTypeField field = new DataTypeField(this.fieldNameGenerator.getUniqueName(spn.getAtomP().getRat().getName()));
            field.setType(BasicType.byName(spn.getAtomP().getRat().getBtype()));
            field.isList(CardinalityHelper.isList(spn.getAtomP().getCard()));
            field.isNullable(CardinalityHelper.isOptional(spn.getAtomP().getCard()));
            dataType.addField(field);
        } else if (spn.getTr() != null) {
            DataTypeField field = new DataTypeField(this.fieldNameGenerator.getUniqueName(spn.getTr().getName()));
            field.setType(this.convert(spn.getTr().getDcref()));
            field.isList(CardinalityHelper.isList(spn.getTr().getCard()));
            field.isNullable(CardinalityHelper.isOptional(spn.getTr().getCard()));
            dataType.addField(field);
        } else if (spn.getGenP() != null) {
            // empty if block
        }
    }

    private String getUniqueTypeName(String initialName) {
        String name = initialName;
        if (name == null || "".equals(name)) {
            return this.getUniqueTypeName("AnonymousType");
        }
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        Set alreadyExistingTypeNames = this.model.getDataTypes().stream().map(d -> d.getName()).collect(Collectors.toSet());
        String baseName = name;
        int counter = 2;
        while (alreadyExistingTypeNames.contains(name)) {
            name = baseName + "_" + counter;
            ++counter;
        }
        return name;
    }
}

