/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.composition.views;

import io.mdsl.generator.model.composition.Event;
import io.mdsl.generator.model.composition.views.Path;
import io.mdsl.generator.model.composition.views.PathElement;
import io.mdsl.utils.MDSLLogger;
import java.util.ArrayList;
import java.util.Collection;

public class PathCollection {
    private ArrayList<Path> paths = new ArrayList();

    public void clear() {
        this.paths.clear();
    }

    public int size() {
        return this.paths.size();
    }

    public Path getPath(int index) {
        return this.paths.get(index);
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public void insertAtStartOfAllPaths(PathElement aggregateIn) {
        for (Path existingPath : this.paths) {
            existingPath.insertEmissionAtStart(aggregateIn);
        }
    }

    public void mergeWithPathCollection(PathCollection collection) {
        if (collection != null) {
            if (this.paths.size() == 1 && this.paths.get(0).length() == 0) {
                this.paths = collection.paths;
            } else {
                this.paths.addAll(collection.paths);
            }
        }
    }

    public void addRawPaths(Collection<Path> paths) {
        paths.addAll(paths);
    }

    public void addRawCollection(Collection<PathCollection> pcl) {
        for (PathCollection nextCollection : pcl) {
            this.paths.addAll(nextCollection.asRawCollection());
        }
    }

    private Collection<? extends Path> asRawCollection() {
        return this.paths;
    }

    public void addEmissionToAllPaths(PathElement emission) {
        this.paths.forEach(path -> path.addEmission(emission));
    }

    public void addEmissionAtStartOfAllPaths(PathElement aggregation) {
        this.paths.forEach(path -> this.insertAtStartOfAllPaths(aggregation));
    }

    public PathCollection cloneDeeply() {
        PathCollection clonedCollection = new PathCollection();
        for (Path pathToBeCloned : this.paths) {
            Path clonedPath = pathToBeCloned.cloneDeeply();
            clonedCollection.addPath(clonedPath);
        }
        return clonedCollection;
    }

    public void mergeEachPathInSecondCollectionIntoEachExistingPath(PathCollection pathsToMergedIn) {
        for (Path existingPath : this.paths) {
            for (Path nextPathToBeMergedIn : pathsToMergedIn.paths) {
                existingPath.addPath(nextPathToBeMergedIn);
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Path collection overview: \n" + this.dumpSizeInfo() + "\n");
        result.append("Paths in (event)command syntax: \n");
        for (Path path : this.paths) {
            result.append(path.toString() + "\n");
        }
        return result.toString();
    }

    public String dumpSizeInfo() {
        StringBuffer result = new StringBuffer("- Path collection has " + this.paths.size() + " entries\n");
        int index = 0;
        for (Path path : this.paths) {
            result.append("-- Path " + index++ + " has size " + path.length() + "\n");
        }
        return result.toString();
    }

    public String dump(boolean withSizeInfo) {
        StringBuffer result = new StringBuffer();
        if (withSizeInfo) {
            result.append("- Path collection has " + this.paths.size() + " entries\n");
        }
        for (Path path : this.paths) {
            if (withSizeInfo) {
                result.append("-- Path has size " + path.length() + "\n");
            }
            result.append(path.dump() + "\n");
        }
        return result.toString();
    }

    public int numberOfInvocations() {
        int result = 0;
        for (Path path : this.paths) {
            result += path.length();
        }
        return result;
    }

    public boolean eventAlreadyAppearsInPaths(Event event) {
        for (Path nextPath : this.paths) {
            for (PathElement nextHop : nextPath.getEmissions()) {
                if (!nextHop.getSource().equals(event.getName())) continue;
                MDSLLogger.reportInformation("(PC) event found in paths " + event.getName());
                return true;
            }
        }
        MDSLLogger.reportInformation("(PC) event NOT found in paths " + event.getName());
        return false;
    }
}

