/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.composition.views;

import io.mdsl.generator.model.composition.views.PathElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class Path {
    private LinkedHashMap<String, PathElement> parts = new LinkedHashMap();

    public Path() {
    }

    public Path(Path pathSoFar) {
        Collection<PathElement> emissions = pathSoFar.getEmissions();
        emissions.forEach(emission -> this.parts.put(emission.getSource(), (PathElement)emission));
    }

    public Path cloneDeeply() {
        Path result = new Path();
        for (Map.Entry<String, PathElement> nextPart : this.parts.entrySet()) {
            PathElement nextEmission = new PathElement(nextPart.getValue().getSource(), nextPart.getValue().getSink());
            result.addEmission(nextEmission);
        }
        return result;
    }

    public Path addEmission(PathElement flowStep) {
        this.parts.put(flowStep.getName(), flowStep);
        return this;
    }

    public void insertEmissionAtStart(PathElement newElement) {
        Path tmp = this.cloneDeeply();
        this.parts.clear();
        this.parts.put(newElement.getName(), newElement);
        tmp.getEmissions().forEach(emission -> this.parts.put(emission.getName(), (PathElement)emission));
    }

    public void addPaths(ArrayList<Path> paths) {
        for (Path path : paths) {
            this.addPath(path);
        }
    }

    public void addPath(Path path) {
        Collection<PathElement> emissions = path.getEmissions();
        emissions.forEach(emission -> this.parts.put(emission.getSource(), (PathElement)emission));
    }

    public int length() {
        return this.parts.size();
    }

    public String getEventAt(int index) {
        PathElement emissionAt = (PathElement)this.parts.values().toArray()[index];
        return emissionAt.getSource();
    }

    public String getCommandAt(int index) {
        PathElement emissionAt = (PathElement)this.parts.values().toArray()[index];
        return emissionAt.getSink();
    }

    Collection<PathElement> getEmissions() {
        return this.parts.values();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (PathElement part : this.parts.values()) {
            result.append(part.toString());
        }
        return result.toString();
    }

    public String dump() {
        StringBuffer result = new StringBuffer();
        for (PathElement part : this.parts.values()) {
            result.append(part.dump());
        }
        return result.toString();
    }
}

