/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.composition;

import io.mdsl.apiDescription.EventType;
import io.mdsl.generator.model.composition.Event;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class JoinEvent
extends Event {
    private static final String JOIN_CONDITION = "_JOIN_";
    private List<Event> joinedEvents = new ArrayList<Event>();
    int conditionCount = 0;

    public JoinEvent(List<Event> joinedEvents, int conditionCount) {
        super(JoinEvent.joinEventNameFor(joinedEvents));
        this.joinedEvents.addAll(joinedEvents);
        this.conditionCount = conditionCount;
    }

    public JoinEvent(String name, List<Event> joinedEvents, String operator) {
        super(name);
        this.joinedEvents.addAll(joinedEvents);
        this.conditionCount = operator.equals("AND") ? joinedEvents.size() : 1;
    }

    @Override
    public boolean isJoin() {
        return true;
    }

    @Override
    public int getConditionCount() {
        return this.conditionCount;
    }

    @Override
    public List<Event> getJoinedEvents() {
        return this.joinedEvents;
    }

    public static String joinEventNameFor(List<Event> joinedEvents) {
        boolean isFirst = true;
        String result = "";
        for (Event event : joinedEvents) {
            if (isFirst) {
                isFirst = false;
            } else {
                result = result + JOIN_CONDITION;
            }
            result = result + event.getName();
        }
        return result;
    }

    public static String joinEventNameFor(EList<EventType> mdslEvents, String operator) {
        StringBuffer result = new StringBuffer(operator);
        mdslEvents.forEach(event -> result.append("_" + event.getName()));
        return result.toString();
    }
}

