/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.composition;

import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.composition.Command;
import io.mdsl.generator.model.composition.CompositeCommand;
import io.mdsl.generator.model.composition.CompositeEvent;
import java.util.ArrayList;
import java.util.List;

public class Event {
    private static final String CHOICE = "choiceOf";
    protected String name;
    protected List<Command> triggeredAlternativeCommands;

    public Event(String name) {
        this.name = name;
        this.triggeredAlternativeCommands = new ArrayList<Command>();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Event)) {
            return false;
        }
        Event ev = (Event)object;
        return this.name.equals(ev.getName());
    }

    public String getType() {
        return "SIMPLE";
    }

    public String getName() {
        return this.name;
    }

    public boolean isJoin() {
        return false;
    }

    public int getConditionCount() {
        return 0;
    }

    public List<Event> getJoinedEvents() {
        return null;
    }

    public Command addTriggeredCommands(List<Command> triggeredCommands, String operator) {
        if (operator.equals("SIMPLE")) {
            this.triggeredAlternativeCommands.addAll(triggeredCommands);
            return null;
        }
        if (operator.equals("OR") || operator.equals("XOR")) {
            this.triggeredAlternativeCommands.addAll(triggeredCommands);
            return null;
        }
        if (operator.equals("AND")) {
            Command andCommand = this.findOrCreateCompositeCommand(triggeredCommands, operator);
            this.triggeredAlternativeCommands.add(andCommand);
            return andCommand;
        }
        throw new MDSLException("Unknown composite event operator: " + operator);
    }

    private Command findOrCreateCompositeCommand(List<Command> commands, String operator) {
        String composedName = this.createNameOfCompositeCommand(commands, operator);
        for (Command command : this.triggeredAlternativeCommands) {
            if (!command.getName().equals(composedName)) continue;
            return command;
        }
        CompositeCommand result = new CompositeCommand(composedName, commands, operator);
        return result;
    }

    private String createNameOfCompositeCommand(List<Command> commands, String operator) {
        StringBuffer result = new StringBuffer(operator);
        commands.forEach(event -> result.append("_" + event.getName()));
        return result.toString();
    }

    public List<Command> getTriggeredCommands() {
        return this.triggeredAlternativeCommands;
    }

    public String getOptionValue() {
        return CHOICE + this.name;
    }

    public String getOptionBranch(String prefix) {
        return prefix + this.name;
    }

    public List<Event> getComposedEvents() {
        return null;
    }

    public Command getSingleCommand() {
        if (this.triggersSingleCommand()) {
            return this.triggeredAlternativeCommands.get(0);
        }
        throw new IllegalStateException("Expected event to be triggering a single simple (non-composite) command.");
    }

    public boolean isComposite() {
        return this instanceof CompositeEvent;
    }

    public boolean triggersSingleCommand() {
        return this.triggeredAlternativeCommands.size() == 1;
    }

    public boolean triggersSingleSimpleCommand() {
        return this.triggeredAlternativeCommands.size() == 1 && !this.triggeredAlternativeCommands.get(0).isComposite();
    }

    public boolean triggersAndCommandComposition() {
        return this.triggeredAlternativeCommands.size() == 1 && this.triggeredAlternativeCommands.get(0).isComposite();
    }

    public boolean triggersOrCommandComposition() {
        return this.triggeredAlternativeCommands.size() > 1;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(" Event: " + this.name + " (" + this.getClass().getSimpleName() + ")");
        result.append(" triggers " + this.triggeredAlternativeCommands.size() + " command(s): ");
        this.triggeredAlternativeCommands.forEach(command -> result.append(command.getName() + " (" + command.getClass().getSimpleName() + ") "));
        return result.toString() + "\n";
    }

    public List<Command> getAndComposedCommands() {
        if (this.triggersAndCommandComposition()) {
            return this.triggeredAlternativeCommands.get(0).getContainedCommands();
        }
        throw new IllegalStateException("Expected event to be triggering a single composite AND command.");
    }
}

