/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model;

import com.google.common.collect.Lists;
import io.mdsl.generator.model.DataTypeField;
import io.mdsl.generator.model.MDSLType;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;

public class DataType
implements MDSLType {
    private String name;
    private List<DataTypeField> fields;

    public DataType(String name) {
        this.name = name;
        this.fields = Lists.newLinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addField(DataTypeField field) {
        this.fields.add(field);
    }

    public List<DataTypeField> getFields() {
        return Lists.newLinkedList(this.fields);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataType dataType = (DataType)o;
        return this.name.equals(dataType.name);
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public String sampleJSONWithEscapedQuotes(int levelOfDetail) {
        String result = this.sampleJSON(levelOfDetail);
        return result.toString().replaceAll("\"", Matcher.quoteReplacement("\\\""));
    }

    @Override
    public String sampleJSON(int levelOfDetail) {
        StringBuffer result = new StringBuffer("{ ");
        result.append("\"_version\": \"" + this.getRole() + "\"");
        this.fields.forEach(field -> result.append(field.sampleJSON(levelOfDetail)));
        result.append("}");
        return result.toString();
    }

    private String getRole() {
        return "undefined";
    }
}

