/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.jolie.converter;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.AnonymousFieldNameGenerator;
import io.mdsl.generator.jolie.converter.OperationModel;
import io.mdsl.generator.jolie.converter.TypeModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class MDSL2JolieConverter {
    private ServiceSpecificationAdapter mdslSpecification;
    private static final String DEFAULT_TYPE = "msg: string";
    private static final String UNDEFINED = "undefined";
    private AnonymousFieldNameGenerator fieldNameGenerator;

    public MDSL2JolieConverter(ServiceSpecification mdslSpecification) {
        this.mdslSpecification = new ServiceSpecificationAdapter(mdslSpecification);
        this.fieldNameGenerator = new AnonymousFieldNameGenerator();
    }

    public void convertOperations(EndpointContract endpoint, HashMap<String, OperationModel> result) {
        for (Operation operation : endpoint.getOps()) {
            String mep = operation.getMep();
            String requestSignature = this.convertMessageStructure(operation.getRequestMessage());
            String responseSignature = this.convertMessageStructure(operation.getResponseMessage());
            OperationModel om = new OperationModel(operation.getName(), requestSignature, responseSignature, this.convertResponsibility(operation.getResponsibility()), mep);
            result.put(operation.getName(), om);
        }
    }

    private String convertMessageStructure(DataTransferRepresentation dtr) {
        if (dtr == null) {
            return DEFAULT_TYPE;
        }
        StringBuffer result = new StringBuffer();
        ElementStructure payload = dtr.getPayload();
        this.convertElementStructure(payload, result);
        return result.toString();
    }

    private void convertElementStructure(ElementStructure representationElement, StringBuffer result) {
        if (representationElement.getNp() != null) {
            SingleParameterNode simpleParameter = representationElement.getNp();
            this.convertSingleParameterNode(simpleParameter, result);
        } else if (representationElement.getApl() != null) {
            this.convertAtomicParameterList(representationElement.getApl(), result);
        } else if (representationElement.getPt() != null) {
            ParameterTree pt = representationElement.getPt();
            this.convertParameterTree(pt, result);
        } else if (representationElement.getPf() != null) {
            this.convertParameterForest(representationElement.getPf(), result);
        } else {
            throw new MDSLException("Unexpected type of element structure");
        }
    }

    private void convertTypeReference(TypeReference typeRef, StringBuffer result) {
        String parameterName = typeRef.getName();
        parameterName = this.createNameIfEmpty(parameterName);
        parameterName = this.handleCardinality(typeRef.getCard(), parameterName);
        result.append(parameterName + ": " + typeRef.getDcref().getName() + " ");
    }

    private void convertParameterForest(ParameterForest pf, StringBuffer result) {
        LinkedList trees = Lists.newLinkedList();
        trees.add(pf.getPtl().getFirst());
        trees.addAll(pf.getPtl().getNext());
        for (ParameterTree tree : trees) {
            String attrName = this.fieldNameGenerator.getUniqueName(tree.getName());
            String typeName = this.deriveTypeNameFromParameterName(attrName);
            typeName = this.handleCardinality(tree.getCard(), typeName);
            StringBuffer nestedResult = new StringBuffer();
            this.convertParameterTree(tree, nestedResult);
            result.append(typeName);
            result.append(": void { ");
            result.append(nestedResult);
            result.append("} ");
        }
    }

    private void convertParameterTree(ParameterTree pt, StringBuffer result) {
        String attrName = this.fieldNameGenerator.getUniqueName(pt.getName());
        String typeName = this.deriveTypeNameFromParameterName(attrName);
        typeName = this.handleCardinality(pt.getCard(), typeName);
        result.append(typeName);
        result.append(": void { ");
        LinkedList treeNodes = Lists.newLinkedList();
        treeNodes.add(pt.getFirst());
        treeNodes.addAll(pt.getNexttn());
        for (TreeNode treeNode : treeNodes) {
            this.convertTreeNode(treeNode, result);
        }
        result.append("} ");
    }

    private void convertTreeNode(TreeNode treeNode, StringBuffer result) {
        if (treeNode.getPn() != null && treeNode.getPn().getGenP() != null) {
            if (treeNode.getPn().getGenP().getName() != null && !"".equals(treeNode.getPn().getGenP().getName())) {
                result.append(new AnonymousFieldNameGenerator().getUniqueName(treeNode.getPn().getGenP().getName()) + ": void ");
            } else {
                result.append("unspecifiedType: void ");
            }
        } else if (treeNode.getPn() != null) {
            StringBuffer nestedResult = new StringBuffer();
            this.convertSingleParameterNode(treeNode.getPn(), nestedResult);
            result.append(nestedResult);
        } else if (treeNode.getApl() != null) {
            AtomicParameterList list = treeNode.getApl();
            StringBuffer nestedResult = new StringBuffer();
            this.convertAtomicParameterList(list, nestedResult);
            result.append(nestedResult);
        } else if (treeNode.getChildren() != null) {
            ParameterTree subTree = treeNode.getChildren();
            StringBuffer nestedResult = new StringBuffer();
            this.convertParameterTree(subTree, nestedResult);
            result.append(nestedResult);
        }
    }

    private void convertSingleParameterNode(SingleParameterNode spn, StringBuffer result) {
        if (spn.getAtomP() != null) {
            this.convertAtomicParameter(spn.getAtomP(), result);
        } else if (spn.getGenP() != null) {
            GenericParameter genericParameter = spn.getGenP();
            String parameterName = genericParameter.getName();
            parameterName = this.createNameIfEmpty(parameterName);
            result.append(parameterName + ": void /* placeholder parameter */");
        } else if (spn.getTr() != null) {
            this.convertTypeReference(spn.getTr(), result);
        } else {
            throw new MDSLException("Unknown type of spn");
        }
    }

    private void convertAtomicParameterList(AtomicParameterList apl, StringBuffer result) {
        String attrName = this.fieldNameGenerator.getUniqueName(apl.getName());
        String typeName = this.deriveTypeNameFromParameterName(attrName);
        StringBuffer nestedResult = new StringBuffer();
        typeName = this.handleCardinality(apl.getCard(), typeName);
        nestedResult.append(typeName);
        nestedResult.append(": void { ");
        LinkedList<AtomicParameter> parameters = new LinkedList<AtomicParameter>();
        parameters.add(apl.getFirst());
        parameters.addAll((Collection<AtomicParameter>)apl.getNextap());
        for (AtomicParameter ap : parameters) {
            StringBuffer nextResult = new StringBuffer();
            this.convertAtomicParameter(ap, nextResult);
            nestedResult.append(nextResult);
            nestedResult.append("\n\t");
        }
        nestedResult.append("} ");
        result.append(nestedResult.toString());
    }

    private void convertAtomicParameter(AtomicParameter ap, StringBuffer result) {
        RoleAndType rat = ap.getRat();
        String name = rat.getName();
        name = this.createNameIfEmpty(name);
        String role = rat.getRole();
        String type = rat.getBtype();
        type = type != null ? this.convertBaseType(type) : "string";
        name = this.handleCardinality(ap.getCard(), name);
        result.append(name + ": " + type + " /* data type role: " + role + " */ ");
    }

    private String createNameIfEmpty(String parameterName) {
        return this.fieldNameGenerator.getUniqueName(parameterName);
    }

    private String handleCardinality(Cardinality card, String name) {
        if (card == null) {
            return name;
        }
        if (card.getExactlyOne() != null) {
            return name;
        }
        if (card.getAtLeastOne() != null) {
            return name + "[1,*]";
        }
        if (card.getZeroOrMore() != null) {
            return name + "[0,*]";
        }
        if (card.getZeroOrOne() != null) {
            return name + "[0,1]";
        }
        throw new MDSLException("Unknown cardinality of " + name);
    }

    private String convertBaseType(String type) {
        return type;
    }

    private String deriveTypeNameFromParameterName(String attrName) {
        return attrName;
    }

    private String convertResponsibility(OperationResponsibility responsibility) {
        if (responsibility == null) {
            return UNDEFINED;
        }
        if (responsibility.getCf() != null) {
            return responsibility.getCf();
        }
        if (responsibility.getSco() != null) {
            return responsibility.getSco();
        }
        if (responsibility.getSto() != null) {
            return responsibility.getSto();
        }
        if (responsibility.getRo() != null) {
            return responsibility.getRo();
        }
        if (responsibility.getOther() != null) {
            return responsibility.getOther();
        }
        return UNDEFINED;
    }

    public HashMap<String, OperationModel> convertEndpoints() {
        HashMap<String, OperationModel> result = new HashMap<String, OperationModel>();
        for (EndpointContract endpoint : this.mdslSpecification.getEndpointContracts()) {
            this.convertOperations(endpoint, result);
        }
        return result;
    }

    public HashMap<String, TypeModel> convertDataTypes() {
        HashMap<String, TypeModel> result = new HashMap<String, TypeModel>();
        for (DataContract dc : this.mdslSpecification.getTypes()) {
            StringBuffer convertedType = new StringBuffer();
            this.convertElementStructure(dc.getStructure(), convertedType);
            String tname = dc.getName();
            TypeModel tdefinition = new TypeModel(tname, convertedType.toString());
            result.put(tname, tdefinition);
        }
        return result;
    }
}

