/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.freemarker.FreemarkerEngineWrapper;
import io.mdsl.generator.java.CapitalizeMethod;
import io.mdsl.generator.java.JavaOperationNameResolver;
import io.mdsl.generator.java.JavaPackageResolver;
import io.mdsl.generator.java.JavaPrimitiveTypeCheckingMethod;
import io.mdsl.generator.java.JavaPrimitiveTypeValueGenerationMethod;
import io.mdsl.generator.java.JavaTypeMappingMethod;
import io.mdsl.generator.model.DataType;
import io.mdsl.generator.model.EndpointContract;
import io.mdsl.generator.model.MDSLGeneratorModel;
import io.mdsl.generator.model.converter.MDSL2GeneratorModelConverter;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class JavaGenerator
extends AbstractMDSLGenerator {
    private ServiceSpecificationAdapter mdsl;
    private MDSLGeneratorModel model;
    private IFileSystemAccess2 fsa;

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        this.mdsl = new ServiceSpecificationAdapter(mdslSpecification);
        this.model = new MDSL2GeneratorModelConverter(this.mdsl).convert();
        this.fsa = fsa;
        this.generateJavaCode4Endpoint();
    }

    private void generateClasses4DataTypes(EndpointContract endpoint) {
        for (DataType contract : this.model.getDataTypes().stream().filter(d -> !d.getName().equals("VoidResponse")).collect(Collectors.toList())) {
            FreemarkerEngineWrapper dataTypeEngine = this.getEngine("DataType.java.ftl");
            dataTypeEngine.registerCustomData("dataTypeName", contract.getName());
            dataTypeEngine.registerCustomData("endpointName", endpoint.getName());
            this.generateFile(endpoint, "/types/" + this.capitalize(contract.getName()) + ".java", dataTypeEngine.generate(this.mdsl));
        }
    }

    private void generateJavaCode4Endpoint() {
        for (EndpointContract endpoint : this.model.getEndpoints()) {
            this.generateClasses4DataTypes(endpoint);
            FreemarkerEngineWrapper interfaceEngine = this.getEngine("EndpointInterface.java.ftl");
            interfaceEngine.registerCustomData("endpointName", endpoint.getName());
            this.generateFile(endpoint, "/services/" + this.capitalize(endpoint.getName()) + ".java", interfaceEngine.generate(this.mdsl));
            FreemarkerEngineWrapper implEngine = this.getEngine("EndpointImplementation.java.ftl");
            implEngine.registerCustomData("endpointName", endpoint.getName());
            this.generateFile(endpoint, "/services/impl/" + this.capitalize(endpoint.getName()) + "Impl.java", implEngine.generate(this.mdsl));
            FreemarkerEngineWrapper testEngine = this.getEngine("EndpointTest.java.ftl");
            testEngine.registerCustomData("endpointName", endpoint.getName());
            this.generateFile(endpoint, "/services/test/" + this.capitalize(endpoint.getName()) + "Test.java", testEngine.generate(this.mdsl));
        }
    }

    private void generateFile(EndpointContract endpoint, String filename, String content) {
        this.fsa.generateFile(new JavaPackageResolver().getJavaPackage(this.model, endpoint).replace(".", "/") + filename, (CharSequence)content);
    }

    private FreemarkerEngineWrapper getEngine(String templateName) {
        FreemarkerEngineWrapper engine = new FreemarkerEngineWrapper(JavaGenerator.class, "java/" + templateName);
        this.registerCommonCustomData(engine);
        return engine;
    }

    private void registerCommonCustomData(FreemarkerEngineWrapper engine) {
        engine.registerCustomData("mapType", new JavaTypeMappingMethod());
        engine.registerCustomData("isPrimitiveType", new JavaPrimitiveTypeCheckingMethod());
        engine.registerCustomData("generateRandomValue4PrimitiveType", new JavaPrimitiveTypeValueGenerationMethod());
        engine.registerCustomData("capitalize", new CapitalizeMethod());
        engine.registerCustomData("resolveOperationName", new JavaOperationNameResolver());
        engine.registerCustomData("resolveJavaPackage", new JavaPackageResolver());
    }

    private String capitalize(String name) {
        if (name == null || "".equals(name)) {
            return "";
        }
        return name.length() == 1 ? name.substring(0, 1).toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

