/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.freemarker.FreemarkerEngineWrapper;
import io.mdsl.generator.graphql.GraphQLOperationInputTypeNameResolver;
import io.mdsl.generator.graphql.GraphQLSimpleTypeMappingMethod;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class GraphQLGenerator
extends AbstractMDSLGenerator {
    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            FreemarkerEngineWrapper fmew = new FreemarkerEngineWrapper(GraphQLGenerator.class, "MDSL2GraphQL.ftl");
            fmew.registerCustomData("graphQLEndpointName", endpoint.getName());
            fmew.registerCustomData("mapType", new GraphQLSimpleTypeMappingMethod());
            fmew.registerCustomData("resolveOperationInputName", new GraphQLOperationInputTypeNameResolver());
            fsa.generateFile(inputFileURI.trimFileExtension().lastSegment() + "_" + endpoint.getName() + ".graphql", (CharSequence)fmew.generate(mdslSpecification));
        }
    }
}

