/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.model.MDSLGeneratorModel;
import io.mdsl.generator.model.converter.MDSL2GeneratorModelConverter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class GenModelYAMLExporter
extends AbstractMDSLGenerator {
    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        MDSLGeneratorModel genModel = new MDSL2GeneratorModelConverter(mdslSpecification).convert();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        try {
            fsa.generateFile(inputFileURI.trimFileExtension().lastSegment() + "_GeneratorModel.yaml", (CharSequence)mapper.writeValueAsString((Object)genModel));
        }
        catch (JsonProcessingException e) {
            throw new MDSLException("Could not serialize generator model as YAML.", (Exception)((Object)e));
        }
    }
}

