/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import io.mdsl.MDSLResource;
import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.ChannelContract;
import io.mdsl.apiDescription.ChannelPathWithParams;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Message;
import io.mdsl.apiDescription.OneWayChannel;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.Payload;
import io.mdsl.apiDescription.ReplyChannel;
import io.mdsl.apiDescription.RequestChannel;
import io.mdsl.apiDescription.RequestReplyChannel;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.AbstractMDSLGenerator;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;

public class AsyncMDSLGenerator
extends AbstractMDSLGenerator {
    @Override
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            MDSLResource sourceSpec = new MDSLResource(resource);
            this.addChannels(sourceSpec);
            sourceSpec.save(null);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new MDSLException("Could not save transformed MDSL " + resource.getURI(), e);
        }
    }

    private void addChannels(MDSLResource sourceSpec) {
        ServiceSpecification mdslSpecification = sourceSpec.getServiceSpecification();
        for (EndpointContract endpointType : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            this.transformEndpointTypeIntoAsyncMDSLChannel(mdslSpecification, endpointType);
        }
    }

    private void transformEndpointTypeIntoAsyncMDSLChannel(ServiceSpecification mdslSpecification, EndpointContract endpointType) {
        for (Operation operation : endpointType.getOps()) {
            DataTransferRepresentation inDtrClone;
            DataTransferRepresentation inDtr = operation.getRequestMessage();
            DataTransferRepresentation outDtr = operation.getResponseMessage();
            String suggestedName = endpointType.getName() + "_" + operation.getName();
            ChannelContract channelContractType = null;
            if (inDtr != null && outDtr != null) {
                inDtrClone = (DataTransferRepresentation)EcoreUtil.copy((EObject)inDtr);
                DataTransferRepresentation outDtrClone = (DataTransferRepresentation)EcoreUtil.copy((EObject)outDtr);
                channelContractType = this.createRequestReplyChannel(suggestedName, operation, inDtrClone, outDtrClone);
            } else if (inDtr != null) {
                inDtrClone = (DataTransferRepresentation)EcoreUtil.copy((EObject)inDtr);
                channelContractType = this.createOneWayChannel(suggestedName, operation, inDtrClone);
            } else {
                throw new IllegalArgumentException("Operation " + operation.getName() + "in endpoint type " + endpointType.getName() + " does not have a request message.");
            }
            mdslSpecification.getContracts().add((Object)channelContractType);
        }
    }

    private ChannelContract createOneWayChannel(String suggestedName, Operation operation, DataTransferRepresentation inDtrClone) {
        ChannelContract channelContractType = ApiDescriptionFactory.eINSTANCE.createChannelContract();
        channelContractType.setName(suggestedName);
        OneWayChannel owChannel = ApiDescriptionFactory.eINSTANCE.createOneWayChannel();
        owChannel.setDescription("One way channel for " + suggestedName);
        owChannel.setPath(this.createPath(suggestedName + "OneWayChannel"));
        String accAndProd = "'accepts' 'and' 'produces'";
        owChannel.setAcceptsAndProduces(accAndProd);
        owChannel.setMessage(this.createMessage(suggestedName + "Message", inDtrClone));
        channelContractType.setConversationType(owChannel);
        return channelContractType;
    }

    private ChannelContract createRequestReplyChannel(String suggestedName, Operation operation, DataTransferRepresentation inDtrClone, DataTransferRepresentation outDtrClone) {
        ChannelContract channelContractType = ApiDescriptionFactory.eINSTANCE.createChannelContract();
        channelContractType.setName(suggestedName);
        RequestReplyChannel rrChannel = ApiDescriptionFactory.eINSTANCE.createRequestReplyChannel();
        this.setRequestChannel(rrChannel, operation.getName(), inDtrClone);
        this.setReplyChannel(rrChannel, operation.getName(), outDtrClone);
        channelContractType.setConversationType(rrChannel);
        return channelContractType;
    }

    private void setRequestChannel(RequestReplyChannel rrChannel, String name, DataTransferRepresentation requestMessage) {
        if (requestMessage == null) {
            throw new MDSLException(name + " seems to have an empty request payload.");
        }
        RequestChannel reqCh = ApiDescriptionFactory.eINSTANCE.createRequestChannel();
        reqCh.setName(name + "RequestChannel");
        reqCh.setPath(this.createPath(name + "RequestChannel"));
        reqCh.setPayload(this.createPayload(requestMessage));
        rrChannel.setRequest(reqCh);
    }

    private void setReplyChannel(RequestReplyChannel rrChannel, String name, DataTransferRepresentation responseMessage) {
        if (responseMessage == null) {
            throw new MDSLException(name + " seems to have an empty response payload.");
        }
        ReplyChannel replCh = ApiDescriptionFactory.eINSTANCE.createReplyChannel();
        replCh.setName(name + "ReplyChannel");
        replCh.setPath(this.createPath(name + "ReplyChannel"));
        replCh.setPayload(this.createPayload(responseMessage));
        rrChannel.setReply(replCh);
    }

    private Message createMessage(String name, DataTransferRepresentation messagePayload) {
        Message result = ApiDescriptionFactory.eINSTANCE.createMessage();
        result.setName(name);
        result.setPayload(this.createPayload(messagePayload));
        result.setDeliveringPayload(true);
        return result;
    }

    private Payload createPayload(DataTransferRepresentation payload) {
        Payload result = ApiDescriptionFactory.eINSTANCE.createPayload();
        result.setSchema(payload);
        return result;
    }

    private ChannelPathWithParams createPath(String address) {
        ChannelPathWithParams path = ApiDescriptionFactory.eINSTANCE.createChannelPathWithParams();
        path.setPath("/" + address + "Path");
        return path;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpointContract : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
        }
    }
}

