/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.jackson;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.AbstractModelConverter;
import io.swagger.v3.core.jackson.JAXBAnnotationsHelper;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.media.XML;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    Logger LOGGER = LoggerFactory.getLogger(ModelResolver.class);
    public static final String SET_PROPERTY_OF_COMPOSED_MODEL_AS_SIBLING = "composed-model-properties-as-sibiling";
    public static final String SET_PROPERTY_OF_ENUMS_AS_REF = "enums-as-ref";
    public static boolean composedModelPropertiesAsSibling = System.getProperty("composed-model-properties-as-sibiling") != null;
    public static boolean enumsAsRef = System.getProperty("enums-as-ref") != null;

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ModelResolver(ObjectMapper mapper, TypeNameResolver typeNameResolver) {
        super(mapper, typeNameResolver);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> next) {
        Discriminator discriminator;
        XML xml;
        boolean isComposedSchema;
        PrimitiveType primitiveType;
        AnnotatedType aType;
        String asName;
        io.swagger.v3.oas.annotations.media.Schema resolvedSchemaAnnotation;
        boolean isPrimitive = false;
        StringSchema model = null;
        if (annotatedType == null) {
            return null;
        }
        if (this.shouldIgnoreClass(annotatedType.getType())) {
            return null;
        }
        JavaType type = annotatedType.getType() instanceof JavaType ? (JavaType)annotatedType.getType() : this._mapper.constructType(annotatedType.getType());
        Annotation resolvedSchemaOrArrayAnnotation = AnnotationsUtils.mergeSchemaAnnotations(annotatedType.getCtxAnnotations(), type);
        io.swagger.v3.oas.annotations.media.Schema schema = resolvedSchemaOrArrayAnnotation == null ? null : (resolvedSchemaAnnotation = resolvedSchemaOrArrayAnnotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? ((io.swagger.v3.oas.annotations.media.ArraySchema)resolvedSchemaOrArrayAnnotation).schema() : (io.swagger.v3.oas.annotations.media.Schema)resolvedSchemaOrArrayAnnotation);
        io.swagger.v3.oas.annotations.media.ArraySchema resolvedArrayAnnotation = resolvedSchemaOrArrayAnnotation == null ? null : (resolvedSchemaOrArrayAnnotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? (io.swagger.v3.oas.annotations.media.ArraySchema)resolvedSchemaOrArrayAnnotation : null);
        BeanDescription recurBeanDesc = this._mapper.getSerializationConfig().introspect(type);
        HashSet<String> visited = new HashSet<String>();
        JsonSerialize jsonSerialize = (JsonSerialize)recurBeanDesc.getClassAnnotations().get(JsonSerialize.class);
        while (jsonSerialize != null && !Void.class.equals((Object)jsonSerialize.as()) && !visited.contains(asName = jsonSerialize.as().getName())) {
            visited.add(asName);
            recurBeanDesc = this._mapper.getSerializationConfig().introspect(this._mapper.constructType((Type)jsonSerialize.as()));
            jsonSerialize = (JsonSerialize)recurBeanDesc.getClassAnnotations().get(JsonSerialize.class);
        }
        BeanDescription beanDesc = recurBeanDesc;
        String name = annotatedType.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            if (!annotatedType.isSkipSchemaName() && resolvedSchemaAnnotation != null && !resolvedSchemaAnnotation.name().isEmpty()) {
                name = resolvedSchemaAnnotation.name();
            }
            if (StringUtils.isBlank((CharSequence)name) && !ReflectionUtils.isSystemType(type)) {
                name = this._typeName(type, beanDesc);
            }
        }
        name = this.decorateModelName(annotatedType, name);
        if (resolvedSchemaAnnotation != null && StringUtils.isNotEmpty((CharSequence)resolvedSchemaAnnotation.ref())) {
            if (resolvedArrayAnnotation == null) {
                return new Schema().$ref(resolvedSchemaAnnotation.ref()).name(name);
            }
            ArraySchema schema2 = new ArraySchema();
            this.resolveArraySchema(annotatedType, schema2, resolvedArrayAnnotation);
            return schema2.items(new Schema().$ref(resolvedSchemaAnnotation.ref()).name(name));
        }
        if (!annotatedType.isSkipOverride() && resolvedSchemaAnnotation != null && !Void.class.equals((Object)resolvedSchemaAnnotation.implementation())) {
            Class cls = resolvedSchemaAnnotation.implementation();
            this.LOGGER.debug("overriding datatype from {} to {}", (Object)type, (Object)cls.getName());
            Annotation[] ctxAnnotation = null;
            if (resolvedArrayAnnotation != null && annotatedType.getCtxAnnotations() != null) {
                ArrayList<Annotation> annList = new ArrayList<Annotation>();
                for (Annotation a : annotatedType.getCtxAnnotations()) {
                    if (a instanceof ArraySchema) continue;
                    annList.add(a);
                }
                annList.add((Annotation)resolvedSchemaAnnotation);
                ctxAnnotation = annList.toArray(new Annotation[annList.size()]);
            } else {
                ctxAnnotation = annotatedType.getCtxAnnotations();
            }
            aType = new AnnotatedType().type(cls).ctxAnnotations(ctxAnnotation).parent(annotatedType.getParent()).name(annotatedType.getName()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).propertyName(annotatedType.getPropertyName()).skipOverride(true);
            if (resolvedArrayAnnotation != null) {
                ArraySchema schema3 = new ArraySchema();
                this.resolveArraySchema(annotatedType, schema3, resolvedArrayAnnotation);
                Schema innerSchema = null;
                Schema primitive = PrimitiveType.createProperty(cls);
                if (primitive != null) {
                    innerSchema = primitive;
                } else {
                    innerSchema = context.resolve(aType);
                    if (innerSchema != null && "object".equals(innerSchema.getType()) && StringUtils.isNotBlank((CharSequence)innerSchema.getName())) {
                        if (context.getDefinedModels().containsKey(innerSchema.getName())) {
                            innerSchema = new Schema().$ref(RefUtils.constructRef(innerSchema.getName()));
                        }
                    } else if (innerSchema != null && innerSchema.get$ref() != null) {
                        innerSchema = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)innerSchema.get$ref()) ? innerSchema.get$ref() : innerSchema.getName());
                    }
                }
                schema3.setItems(innerSchema);
                return schema3;
            }
            Schema implSchema = context.resolve(aType);
            if (implSchema != null && aType.isResolveAsRef() && "object".equals(implSchema.getType()) && StringUtils.isNotBlank((CharSequence)implSchema.getName())) {
                if (context.getDefinedModels().containsKey(implSchema.getName())) {
                    implSchema = new Schema().$ref(RefUtils.constructRef(implSchema.getName()));
                }
            } else if (implSchema != null && implSchema.get$ref() != null) {
                implSchema = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)implSchema.get$ref()) ? implSchema.get$ref() : implSchema.getName());
            }
            return implSchema;
        }
        if (model == null && !annotatedType.isSkipOverride() && resolvedSchemaAnnotation != null && StringUtils.isNotEmpty((CharSequence)resolvedSchemaAnnotation.type()) && !resolvedSchemaAnnotation.type().equals("object")) {
            primitiveType = PrimitiveType.fromTypeAndFormat(resolvedSchemaAnnotation.type(), resolvedSchemaAnnotation.format());
            if (primitiveType == null) {
                primitiveType = PrimitiveType.fromType((Type)type);
            }
            if (primitiveType == null) {
                primitiveType = PrimitiveType.fromName(resolvedSchemaAnnotation.type());
            }
            if (primitiveType != null) {
                Schema primitive = primitiveType.createProperty();
                model = primitive;
                isPrimitive = true;
            }
        }
        if (model == null && type.isEnumType()) {
            model = new StringSchema();
            this._addEnumProps(type.getRawClass(), (Schema)model);
            isPrimitive = true;
        }
        if (model == null && (primitiveType = PrimitiveType.fromType((Type)type)) != null) {
            model = PrimitiveType.fromType((Type)type).createProperty();
            isPrimitive = true;
        }
        if (!annotatedType.isSkipJsonIdentity()) {
            JsonIdentityInfo jsonIdentityInfo = AnnotationsUtils.getAnnotation(JsonIdentityInfo.class, annotatedType.getCtxAnnotations());
            if (jsonIdentityInfo == null) {
                jsonIdentityInfo = type.getRawClass().getAnnotation(JsonIdentityInfo.class);
            }
            if (model == null && jsonIdentityInfo != null) {
                JsonIdentityReference jsonIdentityReference = AnnotationsUtils.getAnnotation(JsonIdentityReference.class, annotatedType.getCtxAnnotations());
                if (jsonIdentityReference == null) {
                    jsonIdentityReference = type.getRawClass().getAnnotation(JsonIdentityReference.class);
                }
                if ((model = GeneratorWrapper.processJsonIdentity(annotatedType, context, this._mapper, jsonIdentityInfo, jsonIdentityReference)) != null) {
                    return model;
                }
            }
        }
        if (model == null && annotatedType.getJsonUnwrappedHandler() != null && (model = annotatedType.getJsonUnwrappedHandler().apply(annotatedType)) == null) {
            return null;
        }
        if ("Object".equals(name)) {
            return new Schema();
        }
        if (isPrimitive) {
            XML xml2;
            if (annotatedType.isSchemaProperty()) {
                // empty if block
            }
            if ((xml2 = this.resolveXml((Annotated)beanDesc.getClassInfo(), annotatedType.getCtxAnnotations(), resolvedSchemaAnnotation)) != null) {
                model.xml(xml2);
            }
            this.resolveSchemaMembers((Schema)model, annotatedType);
            if (resolvedArrayAnnotation != null) {
                ArraySchema schema4 = new ArraySchema();
                this.resolveArraySchema(annotatedType, schema4, resolvedArrayAnnotation);
                schema4.setItems((Schema)model);
                return schema4;
            }
            if (type.isEnumType() && this.shouldResolveEnumAsRef(resolvedSchemaAnnotation)) {
                context.defineModel(name, (Schema)model, annotatedType, null);
                model = new Schema().$ref(name);
            }
            return model;
        }
        Schema resolvedModel = context.resolve(annotatedType);
        if (resolvedModel != null && name != null && name.equals(resolvedModel.getName())) {
            return resolvedModel;
        }
        Type jsonValueType = this.findJsonValueType(beanDesc);
        if (jsonValueType != null) {
            aType = new AnnotatedType().type(jsonValueType).parent(annotatedType.getParent()).name(annotatedType.getName()).schemaProperty(annotatedType.isSchemaProperty()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).propertyName(annotatedType.getPropertyName()).skipOverride(true);
            return context.resolve(aType);
        }
        List<Class<?>> composedSchemaReferencedClasses = this.getComposedSchemaReferencedClasses(type.getRawClass(), annotatedType.getCtxAnnotations(), resolvedSchemaAnnotation);
        boolean bl = isComposedSchema = composedSchemaReferencedClasses != null;
        if (type.isContainerType()) {
            isComposedSchema = false;
            JavaType keyType = type.getKeyType();
            JavaType valueType = type.getContentType();
            String pName = null;
            if (valueType != null) {
                BeanDescription valueTypeBeanDesc = this._mapper.getSerializationConfig().introspect(valueType);
                pName = this._typeName(valueType, valueTypeBeanDesc);
            }
            Annotation[] schemaAnnotations = null;
            if (resolvedSchemaAnnotation != null) {
                schemaAnnotations = new Annotation[]{resolvedSchemaAnnotation};
            }
            if (keyType != null && valueType != null) {
                if (ReflectionUtils.isSystemType(type) && !annotatedType.isSchemaProperty() && !annotatedType.isResolveAsRef()) {
                    context.resolve(new AnnotatedType().type((Type)valueType).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                    return null;
                }
                Schema addPropertiesSchema = context.resolve(new AnnotatedType().type((Type)valueType).schemaProperty(annotatedType.isSchemaProperty()).ctxAnnotations(schemaAnnotations).skipSchemaName(true).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).propertyName(annotatedType.getPropertyName()).parent(annotatedType.getParent()));
                if (addPropertiesSchema != null) {
                    if (StringUtils.isNotBlank((CharSequence)addPropertiesSchema.getName())) {
                        pName = addPropertiesSchema.getName();
                    }
                    if ("object".equals(addPropertiesSchema.getType()) && pName != null) {
                        if (context.getDefinedModels().containsKey(pName)) {
                            addPropertiesSchema = new Schema().$ref(RefUtils.constructRef(pName));
                        }
                    } else if (addPropertiesSchema.get$ref() != null) {
                        addPropertiesSchema = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)addPropertiesSchema.get$ref()) ? addPropertiesSchema.get$ref() : addPropertiesSchema.getName());
                    }
                }
                Annotation[] mapModel = new MapSchema().additionalProperties((Object)addPropertiesSchema);
                mapModel.name(name);
                model = mapModel;
            } else if (valueType != null) {
                if (ReflectionUtils.isSystemType(type) && !annotatedType.isSchemaProperty() && !annotatedType.isResolveAsRef()) {
                    context.resolve(new AnnotatedType().type((Type)valueType).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                    return null;
                }
                Schema items = context.resolve(new AnnotatedType().type((Type)valueType).schemaProperty(annotatedType.isSchemaProperty()).ctxAnnotations(schemaAnnotations).skipSchemaName(true).resolveAsRef(annotatedType.isResolveAsRef()).propertyName(annotatedType.getPropertyName()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).parent(annotatedType.getParent()));
                if (items == null) {
                    return null;
                }
                if (annotatedType.isSchemaProperty() && annotatedType.getCtxAnnotations() != null && annotatedType.getCtxAnnotations().length > 0 && !"object".equals(items.getType())) {
                    for (Annotation annotation : annotatedType.getCtxAnnotations()) {
                        XmlElement xmlElement;
                        if (!(annotation instanceof XmlElement) || (xmlElement = (XmlElement)annotation) == null || xmlElement.name() == null || "".equals(xmlElement.name()) || "##default".equals(xmlElement.name())) continue;
                        XML xml3 = items.getXml() != null ? items.getXml() : new XML();
                        xml3.setName(xmlElement.name());
                        items.setXml(xml3);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)items.getName())) {
                    pName = items.getName();
                }
                if ("object".equals(items.getType()) && pName != null) {
                    if (context.getDefinedModels().containsKey(pName)) {
                        items = new Schema().$ref(RefUtils.constructRef(pName));
                    }
                } else if (items.get$ref() != null) {
                    items = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)items.get$ref()) ? items.get$ref() : items.getName());
                }
                ArraySchema arrayModel = new ArraySchema().items(items);
                if (this._isSetType(type.getRawClass())) {
                    arrayModel.setUniqueItems(Boolean.valueOf(true));
                }
                arrayModel.name(name);
                model = arrayModel;
            } else if (ReflectionUtils.isSystemType(type) && !annotatedType.isSchemaProperty() && !annotatedType.isResolveAsRef()) {
                return null;
            }
        } else if (isComposedSchema) {
            model = new ComposedSchema().type("object").name(name);
        } else {
            if (this._isOptionalType(type)) {
                AnnotatedType aType2 = new AnnotatedType().type((Type)type.containedType(0)).ctxAnnotations(annotatedType.getCtxAnnotations()).parent(annotatedType.getParent()).schemaProperty(annotatedType.isSchemaProperty()).name(annotatedType.getName()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).propertyName(annotatedType.getPropertyName()).skipOverride(true);
                model = context.resolve(aType2);
                return model;
            }
            model = new Schema().type("object").name(name);
        }
        if (!type.isContainerType() && StringUtils.isNotBlank((CharSequence)name)) {
            context.defineModel(name, (Schema)model, annotatedType, null);
        }
        if ((xml = this.resolveXml((Annotated)beanDesc.getClassInfo(), annotatedType.getCtxAnnotations(), resolvedSchemaAnnotation)) != null) {
            model.xml(xml);
        }
        if (!(model instanceof ArraySchema) || model instanceof ArraySchema && resolvedArrayAnnotation == null) {
            this.resolveSchemaMembers((Schema)model, annotatedType);
        }
        XmlAccessorType xmlAccessorTypeAnnotation = (XmlAccessorType)beanDesc.getClassAnnotations().get(XmlAccessorType.class);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = (JsonIgnoreProperties)beanDesc.getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        ArrayList<Schema> props = new ArrayList<Schema>();
        LinkedHashMap<String, Schema> modelProps = new LinkedHashMap<String, Schema>();
        List properties = beanDesc.findProperties();
        List<String> ignoredProps = this.getIgnoredProperties(beanDesc);
        properties.removeIf(p -> ignoredProps.contains(p.getName()));
        for (BeanPropertyDefinition propDef : properties) {
            void var27_36;
            Annotation propSchemaOrArray;
            io.swagger.v3.oas.annotations.media.ArraySchema ctxArraySchema;
            void var27_39;
            Object altName;
            Member innerMember;
            JsonProperty jsonPropertyAnn;
            Schema property = null;
            String string = propDef.getName();
            Annotation[] annotations = null;
            AnnotatedMember member = propDef.getPrimaryMember();
            if (member == null) {
                BeanDescription deserBeanDesc = this._mapper.getDeserializationConfig().introspect(type);
                List deserProperties = deserBeanDesc.findProperties();
                for (BeanPropertyDefinition prop : deserProperties) {
                    if (!StringUtils.isNotBlank((CharSequence)prop.getInternalName()) || !prop.getInternalName().equals(propDef.getInternalName())) continue;
                    member = prop.getPrimaryMember();
                    break;
                }
            }
            if (!(propDef.getPrimaryMember() == null || (jsonPropertyAnn = (JsonProperty)propDef.getPrimaryMember().getAnnotation(JsonProperty.class)) != null && jsonPropertyAnn.value().equals(string) || member == null || (innerMember = member.getMember()) == null || (altName = innerMember.getName()) == null)) {
                int length = ((String)altName).length();
                for (String prefix : Arrays.asList("get", "is")) {
                    int offset = prefix.length();
                    if (!((String)altName).startsWith(prefix) || length <= offset || Character.isUpperCase(((String)altName).charAt(offset))) continue;
                    Object object = altName;
                    break;
                }
            }
            PropertyMetadata md = propDef.getMetadata();
            if (member == null || this.ignore((Annotated)member, xmlAccessorTypeAnnotation, (String)var27_39, propertiesToIgnore)) continue;
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            altName = member.annotations().iterator();
            while (altName.hasNext()) {
                Annotation a = (Annotation)altName.next();
                annotationList.add(a);
            }
            annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            if (this.hiddenByJsonView(annotations, annotatedType)) continue;
            JavaType propType = member.getType();
            if (propType != null && "void".equals(propType.getRawClass().getName()) && member instanceof AnnotatedMethod) {
                propType = ((AnnotatedMethod)member).getParameterType(0);
            }
            String propSchemaName = null;
            io.swagger.v3.oas.annotations.media.Schema ctxSchema = AnnotationsUtils.getSchemaAnnotation(annotations);
            if (AnnotationsUtils.hasSchemaAnnotation(ctxSchema) && !StringUtils.isBlank((CharSequence)ctxSchema.name())) {
                propSchemaName = ctxSchema.name();
            }
            if (propSchemaName == null && AnnotationsUtils.hasArrayAnnotation(ctxArraySchema = AnnotationsUtils.getArraySchemaAnnotation(annotations)) && AnnotationsUtils.hasSchemaAnnotation(ctxArraySchema.schema()) && !StringUtils.isBlank((CharSequence)ctxArraySchema.schema().name())) {
                propSchemaName = ctxArraySchema.schema().name();
            }
            if (StringUtils.isNotBlank(propSchemaName)) {
                String string2 = propSchemaName;
            }
            io.swagger.v3.oas.annotations.media.Schema propResolvedSchemaAnnotation = (propSchemaOrArray = AnnotationsUtils.mergeSchemaAnnotations(annotations, propType)) == null ? null : (propSchemaOrArray instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? ((io.swagger.v3.oas.annotations.media.ArraySchema)propSchemaOrArray).schema() : (io.swagger.v3.oas.annotations.media.Schema)propSchemaOrArray);
            Schema.AccessMode accessMode = this.resolveAccessMode(propDef, type, propResolvedSchemaAnnotation);
            AnnotatedType aType3 = new AnnotatedType().type((Type)propType).ctxAnnotations(annotations).parent((Schema)model).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).skipSchemaName(true).schemaProperty(true).propertyName((String)var27_36);
            AnnotatedMember propMember = member;
            aType3.jsonUnwrappedHandler(t -> {
                JsonUnwrapped uw = (JsonUnwrapped)propMember.getAnnotation(JsonUnwrapped.class);
                if (uw != null && uw.enabled()) {
                    t.ctxAnnotations(null).jsonUnwrappedHandler(null).resolveAsRef(false);
                    this.handleUnwrapped(props, context.resolve((AnnotatedType)t), uw.prefix(), uw.suffix());
                    return null;
                }
                return new Schema();
            });
            property = this.clone(context.resolve(aType3));
            if (property == null) continue;
            Boolean required = md.getRequired();
            if (required != null && !Boolean.FALSE.equals(required)) {
                this.addRequiredItem((Schema)model, (String)var27_36);
            } else if (propDef.isRequired()) {
                this.addRequiredItem((Schema)model, (String)var27_36);
            }
            if (property.get$ref() == null && accessMode != null) {
                switch (accessMode) {
                    case AUTO: {
                        break;
                    }
                    case READ_ONLY: {
                        property.readOnly(Boolean.valueOf(true));
                        break;
                    }
                    case READ_WRITE: {
                        break;
                    }
                    case WRITE_ONLY: {
                        property.writeOnly(Boolean.valueOf(true));
                        break;
                    }
                }
            }
            BeanDescription propBeanDesc = this._mapper.getSerializationConfig().introspect(propType);
            if (property != null && !propType.isContainerType()) {
                if ("object".equals(property.getType())) {
                    String pName = this._typeName(propType, propBeanDesc);
                    if (StringUtils.isNotBlank((CharSequence)property.getName())) {
                        pName = property.getName();
                    }
                    if (context.getDefinedModels().containsKey(pName)) {
                        property = new Schema().$ref(RefUtils.constructRef(pName));
                    }
                } else if (property.get$ref() != null) {
                    property = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)property.get$ref()) ? property.get$ref() : property.getName());
                }
            }
            property.setName((String)var27_36);
            JAXBAnnotationsHelper.apply((Annotated)propBeanDesc.getClassInfo(), annotations, property);
            this.applyBeanValidatorAnnotations(property, annotations, (Schema)model);
            props.add(property);
        }
        for (Schema prop : props) {
            modelProps.put(prop.getName(), prop);
        }
        if (modelProps.size() > 0) {
            model.setProperties(modelProps);
        }
        if (!type.isContainerType() && StringUtils.isNotBlank((CharSequence)name)) {
            context.defineModel(name, (Schema)model, annotatedType, null);
        }
        if (!this.resolveSubtypes((Schema)model, beanDesc, context)) {
            model.setDiscriminator(null);
        }
        if ((discriminator = this.resolveDiscriminator(type, context)) != null) {
            model.setDiscriminator(discriminator);
        }
        if (resolvedSchemaAnnotation != null) {
            Class not;
            String ref = resolvedSchemaAnnotation.ref();
            if (!StringUtils.isBlank((CharSequence)ref)) {
                model.$ref(ref);
            }
            if (!Void.class.equals((Object)(not = resolvedSchemaAnnotation.not()))) {
                model.not(new Schema().$ref(context.resolve(new AnnotatedType().type(not).jsonViewAnnotation(annotatedType.getJsonViewAnnotation())).getName()));
            }
            if (resolvedSchemaAnnotation.requiredProperties() != null && resolvedSchemaAnnotation.requiredProperties().length > 0 && StringUtils.isNotBlank((CharSequence)resolvedSchemaAnnotation.requiredProperties()[0])) {
                for (String prop : resolvedSchemaAnnotation.requiredProperties()) {
                    this.addRequiredItem((Schema)model, prop);
                }
            }
        }
        if (isComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)model;
            Class[] allOf = resolvedSchemaAnnotation.allOf();
            Class[] classArray = resolvedSchemaAnnotation.anyOf();
            Class[] oneOf = resolvedSchemaAnnotation.oneOf();
            List<Class> allOfFiltered = Stream.of(allOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            allOfFiltered.forEach(c -> {
                Schema allOfRef = context.resolve(new AnnotatedType().type((Type)c).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                Schema refSchema = new Schema().$ref(allOfRef.getName());
                if (composedSchema.getAllOf() == null || !composedSchema.getAllOf().contains(refSchema)) {
                    composedSchema.addAllOfItem(refSchema);
                }
                if (this.isSubtype(beanDesc.getClassInfo(), (Class<?>)c)) {
                    this.removeParentProperties((Schema)composedSchema, allOfRef);
                }
            });
            List<Class> anyOfFiltered = Stream.of(classArray).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            anyOfFiltered.forEach(c -> {
                Schema anyOfRef = context.resolve(new AnnotatedType().type((Type)c).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                composedSchema.addAnyOfItem(new Schema().$ref(anyOfRef.getName()));
                if (this.isSubtype(beanDesc.getClassInfo(), (Class<?>)c)) {
                    this.removeParentProperties((Schema)composedSchema, anyOfRef);
                }
            });
            List<Class> oneOfFiltered = Stream.of(oneOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            oneOfFiltered.forEach(c -> {
                Schema oneOfRef = context.resolve(new AnnotatedType().type((Type)c).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                if (oneOfRef != null) {
                    if (StringUtils.isBlank((CharSequence)oneOfRef.getName())) {
                        composedSchema.addOneOfItem(oneOfRef);
                    } else {
                        composedSchema.addOneOfItem(new Schema().$ref(oneOfRef.getName()));
                    }
                    if (this.isSubtype(beanDesc.getClassInfo(), (Class<?>)c)) {
                        this.removeParentProperties((Schema)composedSchema, oneOfRef);
                    }
                }
            });
            if (!(composedModelPropertiesAsSibling || composedSchema.getAllOf() == null || composedSchema.getAllOf().isEmpty() || composedSchema.getProperties() == null || composedSchema.getProperties().isEmpty())) {
                ObjectSchema propSchema = new ObjectSchema();
                propSchema.properties(composedSchema.getProperties());
                composedSchema.setProperties(null);
                composedSchema.addAllOfItem((Schema)propSchema);
            }
        }
        if (!type.isContainerType() && StringUtils.isNotBlank((CharSequence)name)) {
            context.defineModel(name, (Schema)model, annotatedType, null);
        }
        if (model != null && annotatedType.isResolveAsRef() && (isComposedSchema || "object".equals(model.getType())) && StringUtils.isNotBlank((CharSequence)model.getName())) {
            if (context.getDefinedModels().containsKey(model.getName())) {
                model = new Schema().$ref(RefUtils.constructRef(model.getName()));
            }
        } else if (model != null && model.get$ref() != null) {
            model = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)model.get$ref()) ? model.get$ref() : model.getName());
        }
        if (model != null && resolvedArrayAnnotation != null) {
            if (!"array".equals(model.getType())) {
                ArraySchema schema5 = new ArraySchema();
                schema5.setItems((Schema)model);
                this.resolveArraySchema(annotatedType, schema5, resolvedArrayAnnotation);
                return schema5;
            }
            if (model instanceof ArraySchema) {
                this.resolveArraySchema(annotatedType, (ArraySchema)model, resolvedArrayAnnotation);
            }
        }
        this.resolveDiscriminatorProperty(type, context, (Schema)model);
        return model;
    }

    private boolean shouldResolveEnumAsRef(io.swagger.v3.oas.annotations.media.Schema resolvedSchemaAnnotation) {
        return resolvedSchemaAnnotation != null && resolvedSchemaAnnotation.enumAsRef() || enumsAsRef;
    }

    protected Type findJsonValueType(BeanDescription beanDesc) {
        block3: {
            try {
                Method m = BeanDescription.class.getMethod("findJsonValueAccessor", null);
                AnnotatedMember jsonValueMember = (AnnotatedMember)m.invoke((Object)beanDesc, null);
                if (jsonValueMember != null) {
                    return jsonValueMember.getType();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.LOGGER.warn("jackson BeanDescription.findJsonValueAccessor not found, this could lead to inaccurate result, please update jackson to 2.9+");
                AnnotatedMethod jsonValueMethod = beanDesc.findJsonValueMethod();
                if (jsonValueMethod == null) break block3;
                return jsonValueMethod.getType();
            }
        }
        return null;
    }

    private Schema clone(Schema property) {
        if (property == null) {
            return property;
        }
        try {
            String cloneName = property.getName();
            property = (Schema)Json.mapper().readValue(Json.pretty(property), Schema.class);
            property.setName(cloneName);
        }
        catch (IOException e) {
            this.LOGGER.error("Could not clone property, e");
        }
        return property;
    }

    private boolean isSubtype(AnnotatedClass childClass, Class<?> parentClass) {
        BeanDescription parentDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(parentClass);
        List subTypes = this._intr.findSubtypes((Annotated)parentDesc.getClassInfo());
        if (subTypes == null) {
            return false;
        }
        for (NamedType subtype : subTypes) {
            Class subtypeType = subtype.getType();
            if (!childClass.getRawType().isAssignableFrom(subtypeType)) continue;
            return true;
        }
        return false;
    }

    protected boolean _isOptionalType(JavaType propType) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(propType.getRawClass().getCanonicalName());
    }

    protected void _addEnumProps(Class<?> propClass, Schema property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            if (!(property instanceof StringSchema)) continue;
            StringSchema sp = (StringSchema)property;
            sp.addEnumItem(n);
        }
    }

    protected boolean ignore(Annotated member, XmlAccessorType xmlAccessorTypeAnnotation, String propName, Set<String> propertiesToIgnore) {
        if (propertiesToIgnore.contains(propName)) {
            return true;
        }
        if (member.hasAnnotation(JsonIgnore.class)) {
            return true;
        }
        if (xmlAccessorTypeAnnotation == null) {
            return false;
        }
        return xmlAccessorTypeAnnotation.value().equals((Object)XmlAccessType.NONE) && !member.hasAnnotation(XmlElement.class) && !member.hasAnnotation(XmlAttribute.class) && !member.hasAnnotation(XmlElementRef.class) && !member.hasAnnotation(XmlElementRefs.class) && !member.hasAnnotation(JsonProperty.class);
    }

    private void handleUnwrapped(List<Schema> props, Schema innerModel, String prefix, String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix) && StringUtils.isBlank((CharSequence)prefix)) {
            if (innerModel.getProperties() != null) {
                props.addAll(innerModel.getProperties().values());
            }
        } else {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            if (innerModel.getProperties() != null) {
                for (Schema prop : innerModel.getProperties().values()) {
                    try {
                        Schema clonedProp = (Schema)Json.mapper().readValue(Json.pretty(prop), Schema.class);
                        clonedProp.setName(prefix + prop.getName() + suffix);
                        props.add(clonedProp);
                    }
                    catch (IOException e) {
                        this.LOGGER.error("Exception cloning property", (Throwable)e);
                        return;
                    }
                }
            }
        }
    }

    protected void applyBeanValidatorAnnotations(Schema property, Annotation[] annotations, Schema parent) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                annos.put(anno.annotationType().getName(), anno);
            }
        }
        if (parent != null && (annos.containsKey("javax.validation.constraints.NotNull") || annos.containsKey("javax.validation.constraints.NotBlank") || annos.containsKey("javax.validation.constraints.NotEmpty"))) {
            this.addRequiredItem(parent, property.getName());
        }
        if (annos.containsKey("javax.validation.constraints.Min") && ("integer".equals(property.getType()) || "number".equals(property.getType()))) {
            min = (Min)annos.get("javax.validation.constraints.Min");
            property.setMinimum(new BigDecimal(min.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Max") && ("integer".equals(property.getType()) || "number".equals(property.getType()))) {
            max = (Max)annos.get("javax.validation.constraints.Max");
            property.setMaximum(new BigDecimal(max.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Size")) {
            Size size = (Size)annos.get("javax.validation.constraints.Size");
            if ("integer".equals(property.getType()) || "number".equals(property.getType())) {
                property.setMinimum(new BigDecimal(size.min()));
                property.setMaximum(new BigDecimal(size.max()));
            } else if (property instanceof StringSchema) {
                StringSchema sp = (StringSchema)property;
                sp.minLength(new Integer(size.min()));
                sp.maxLength(new Integer(size.max()));
            } else if (property instanceof ArraySchema) {
                ArraySchema sp = (ArraySchema)property;
                sp.setMinItems(Integer.valueOf(size.min()));
                sp.setMaxItems(Integer.valueOf(size.max()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMin")) {
            min = (DecimalMin)annos.get("javax.validation.constraints.DecimalMin");
            if (property instanceof NumberSchema) {
                NumberSchema ap = (NumberSchema)property;
                ap.setMinimum(new BigDecimal(min.value()));
                ap.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMax")) {
            max = (DecimalMax)annos.get("javax.validation.constraints.DecimalMax");
            if (property instanceof NumberSchema) {
                NumberSchema ap = (NumberSchema)property;
                ap.setMaximum(new BigDecimal(max.value()));
                ap.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.Pattern")) {
            Pattern pattern = (Pattern)annos.get("javax.validation.constraints.Pattern");
            if (property instanceof StringSchema) {
                property.setPattern(pattern.regexp());
            }
        }
    }

    private boolean resolveSubtypes(Schema model, BeanDescription bean, ModelConverterContext context) {
        List types = this._intr.findSubtypes((Annotated)bean.getClassInfo());
        if (types == null) {
            return false;
        }
        this.removeSelfFromSubTypes(types, bean);
        this.removeSuperClassAndInterfaceSubTypes(types, bean);
        boolean count = false;
        Class beanClass = bean.getClassInfo().getAnnotated();
        for (NamedType subtype : types) {
            Class subtypeType = subtype.getType();
            if (!beanClass.isAssignableFrom(subtypeType)) continue;
            Schema subtypeModel = context.resolve(new AnnotatedType().type(subtypeType));
            if (StringUtils.isBlank((CharSequence)subtypeModel.getName()) || subtypeModel.getName().equals(model.getName())) {
                subtypeModel.setName(this._typeNameResolver.nameForType(this._mapper.constructType((Type)subtypeType), TypeNameResolver.Options.SKIP_API_MODEL));
            }
            ComposedSchema composedSchema = null;
            if (!(subtypeModel instanceof ComposedSchema)) {
                composedSchema = (ComposedSchema)new ComposedSchema().title(subtypeModel.getTitle()).name(subtypeModel.getName()).deprecated(subtypeModel.getDeprecated()).additionalProperties(subtypeModel.getAdditionalProperties()).description(subtypeModel.getDescription()).discriminator(subtypeModel.getDiscriminator()).example(subtypeModel.getExample()).exclusiveMaximum(subtypeModel.getExclusiveMaximum()).exclusiveMinimum(subtypeModel.getExclusiveMinimum()).externalDocs(subtypeModel.getExternalDocs()).format(subtypeModel.getFormat()).maximum(subtypeModel.getMaximum()).maxItems(subtypeModel.getMaxItems()).maxLength(subtypeModel.getMaxLength()).maxProperties(subtypeModel.getMaxProperties()).minimum(subtypeModel.getMinimum()).minItems(subtypeModel.getMinItems()).minLength(subtypeModel.getMinLength()).minProperties(subtypeModel.getMinProperties()).multipleOf(subtypeModel.getMultipleOf()).not(subtypeModel.getNot()).nullable(subtypeModel.getNullable()).pattern(subtypeModel.getPattern()).properties(subtypeModel.getProperties()).readOnly(subtypeModel.getReadOnly()).required(subtypeModel.getRequired()).type(subtypeModel.getType()).uniqueItems(subtypeModel.getUniqueItems()).writeOnly(subtypeModel.getWriteOnly()).xml(subtypeModel.getXml()).extensions(subtypeModel.getExtensions());
                composedSchema.setEnum(subtypeModel.getEnum());
            } else {
                composedSchema = (ComposedSchema)subtypeModel;
            }
            Schema refSchema = new Schema().$ref(model.getName());
            if (composedSchema.getAllOf() == null || !composedSchema.getAllOf().contains(refSchema)) {
                composedSchema.addAllOfItem(refSchema);
            }
            this.removeParentProperties((Schema)composedSchema, model);
            if (!(composedModelPropertiesAsSibling || composedSchema.getAllOf() == null || composedSchema.getAllOf().isEmpty() || composedSchema.getProperties() == null || composedSchema.getProperties().isEmpty())) {
                ObjectSchema propSchema = new ObjectSchema();
                propSchema.properties(composedSchema.getProperties());
                composedSchema.setProperties(null);
                composedSchema.addAllOfItem((Schema)propSchema);
            }
            Class currentType = subtype.getType();
            if (!StringUtils.isNotBlank((CharSequence)composedSchema.getName())) continue;
            context.defineModel(composedSchema.getName(), (Schema)composedSchema, new AnnotatedType().type(currentType), null);
        }
        return count;
    }

    private void removeSelfFromSubTypes(List<NamedType> types, BeanDescription bean) {
        Class beanClass = bean.getType().getRawClass();
        types.removeIf(type -> beanClass.equals(type.getType()));
    }

    private void removeSuperClassAndInterfaceSubTypes(List<NamedType> types, BeanDescription bean) {
        Class beanClass = bean.getType().getRawClass();
        Class superClass = beanClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.removeSuperSubTypes(types, superClass);
        }
        if (!types.isEmpty()) {
            Class<?>[] superInterfaces;
            for (Class<?> superInterface : superInterfaces = beanClass.getInterfaces()) {
                this.removeSuperSubTypes(types, superInterface);
                if (types.isEmpty()) break;
            }
        }
    }

    private void removeSuperSubTypes(List<NamedType> resultTypes, Class<?> superClass) {
        JavaType superType = this._mapper.constructType(superClass);
        BeanDescription superBean = this._mapper.getSerializationConfig().introspect(superType);
        List superTypes = this._intr.findSubtypes((Annotated)superBean.getClassInfo());
        if (superTypes != null) {
            resultTypes.removeAll(superTypes);
        }
    }

    private void removeParentProperties(Schema child, Schema parent) {
        Map baseProps = parent.getProperties();
        Map subtypeProps = child.getProperties();
        if (baseProps != null && subtypeProps != null) {
            for (Map.Entry entry : baseProps.entrySet()) {
                if (!((Schema)entry.getValue()).equals(subtypeProps.get(entry.getKey()))) continue;
                subtypeProps.remove(entry.getKey());
            }
        }
        if (subtypeProps == null || subtypeProps.isEmpty()) {
            child.setProperties(null);
        }
    }

    protected List<Class<?>> getComposedSchemaReferencedClasses(Class<?> clazz, Annotation[] ctxAnnotations, io.swagger.v3.oas.annotations.media.Schema schemaAnnotation) {
        if (schemaAnnotation != null) {
            Class[] allOf = schemaAnnotation.allOf();
            Class[] anyOf = schemaAnnotation.anyOf();
            Class[] oneOf = schemaAnnotation.oneOf();
            List<Class<?>> parentClasses = Stream.of(allOf, anyOf, oneOf).flatMap(Stream::of).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            if (!parentClasses.isEmpty()) {
                return parentClasses;
            }
        }
        return null;
    }

    protected String resolveDescription(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !"".equals(schema.description())) {
            return schema.description();
        }
        return null;
    }

    protected String resolveTitle(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.title())) {
            return schema.title();
        }
        return null;
    }

    protected String resolveFormat(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.format())) {
            return schema.format();
        }
        return null;
    }

    protected String resolveDefaultValue(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !schema.defaultValue().isEmpty()) {
            return schema.defaultValue();
        }
        if (a == null) {
            return null;
        }
        XmlElement elem = (XmlElement)a.getAnnotation(XmlElement.class);
        if (elem == null && annotations != null) {
            for (Annotation ann : annotations) {
                if (!(ann instanceof XmlElement)) continue;
                elem = (XmlElement)ann;
                break;
            }
        }
        if (elem != null && !elem.defaultValue().isEmpty() && !"\u0000".equals(elem.defaultValue())) {
            return elem.defaultValue();
        }
        return null;
    }

    protected Object resolveExample(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !schema.example().isEmpty()) {
            try {
                ObjectMapper mapper = ObjectMapperFactory.buildStrictGenericObjectMapper();
                return mapper.readTree(schema.example());
            }
            catch (IOException e) {
                return schema.example();
            }
        }
        return null;
    }

    protected Schema.AccessMode resolveAccessMode(BeanPropertyDefinition propDef, JavaType type, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !schema.accessMode().equals((Object)Schema.AccessMode.AUTO)) {
            return schema.accessMode();
        }
        if (schema != null && schema.readOnly()) {
            return Schema.AccessMode.READ_ONLY;
        }
        if (schema != null && schema.writeOnly()) {
            return Schema.AccessMode.WRITE_ONLY;
        }
        if (propDef == null) {
            return null;
        }
        JsonProperty.Access access = null;
        if (propDef instanceof POJOPropertyBuilder) {
            access = ((POJOPropertyBuilder)propDef).findAccess();
        }
        boolean hasGetter = propDef.hasGetter();
        boolean hasSetter = propDef.hasSetter();
        boolean hasConstructorParameter = propDef.hasConstructorParameter();
        boolean hasField = propDef.hasField();
        if (access == null) {
            BeanDescription beanDesc = this._mapper.getDeserializationConfig().introspect(type);
            List properties = beanDesc.findProperties();
            for (BeanPropertyDefinition prop : properties) {
                if (!StringUtils.isNotBlank((CharSequence)prop.getInternalName()) || !prop.getInternalName().equals(propDef.getInternalName())) continue;
                if (prop instanceof POJOPropertyBuilder) {
                    access = ((POJOPropertyBuilder)prop).findAccess();
                }
                hasGetter = hasGetter || prop.hasGetter();
                hasSetter = hasSetter || prop.hasSetter();
                hasConstructorParameter = hasConstructorParameter || prop.hasConstructorParameter();
                hasField = hasField || prop.hasField();
                break;
            }
        }
        if (access == null) {
            if (!hasGetter && !hasField && (hasConstructorParameter || hasSetter)) {
                return Schema.AccessMode.WRITE_ONLY;
            }
            return null;
        }
        switch (access) {
            case AUTO: {
                return Schema.AccessMode.AUTO;
            }
            case READ_ONLY: {
                return Schema.AccessMode.READ_ONLY;
            }
            case READ_WRITE: {
                return Schema.AccessMode.READ_WRITE;
            }
            case WRITE_ONLY: {
                return Schema.AccessMode.WRITE_ONLY;
            }
        }
        return Schema.AccessMode.AUTO;
    }

    protected Boolean resolveReadOnly(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_ONLY)) {
            return true;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.WRITE_ONLY)) {
            return null;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_WRITE)) {
            return null;
        }
        if (schema != null && schema.readOnly()) {
            return schema.readOnly();
        }
        return null;
    }

    protected Boolean resolveNullable(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.nullable()) {
            return schema.nullable();
        }
        return null;
    }

    protected BigDecimal resolveMultipleOf(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.multipleOf() != 0.0) {
            return new BigDecimal(schema.multipleOf());
        }
        return null;
    }

    protected Integer resolveMaxLength(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.maxLength() != Integer.MAX_VALUE && schema.maxLength() > 0) {
            return schema.maxLength();
        }
        return null;
    }

    protected Integer resolveMinLength(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.minLength() > 0) {
            return schema.minLength();
        }
        return null;
    }

    protected BigDecimal resolveMinimum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && NumberUtils.isNumber((String)schema.minimum())) {
            String filteredMinimum = schema.minimum().replaceAll(",", "");
            return new BigDecimal(filteredMinimum);
        }
        return null;
    }

    protected BigDecimal resolveMaximum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && NumberUtils.isNumber((String)schema.maximum())) {
            String filteredMaximum = schema.maximum().replaceAll(",", "");
            return new BigDecimal(filteredMaximum);
        }
        return null;
    }

    protected Boolean resolveExclusiveMinimum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.exclusiveMinimum()) {
            return schema.exclusiveMinimum();
        }
        return null;
    }

    protected Boolean resolveExclusiveMaximum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.exclusiveMaximum()) {
            return schema.exclusiveMaximum();
        }
        return null;
    }

    protected String resolvePattern(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.pattern())) {
            return schema.pattern();
        }
        return null;
    }

    protected Integer resolveMinProperties(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.minProperties() > 0) {
            return schema.minProperties();
        }
        return null;
    }

    protected Integer resolveMaxProperties(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.maxProperties() > 0) {
            return schema.maxProperties();
        }
        return null;
    }

    protected List<String> resolveRequiredProperties(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.requiredProperties() != null && schema.requiredProperties().length > 0 && StringUtils.isNotBlank((CharSequence)schema.requiredProperties()[0])) {
            return Arrays.asList(schema.requiredProperties());
        }
        return null;
    }

    protected Boolean resolveWriteOnly(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_ONLY)) {
            return null;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.WRITE_ONLY)) {
            return true;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_WRITE)) {
            return null;
        }
        if (schema != null && schema.writeOnly()) {
            return schema.writeOnly();
        }
        return null;
    }

    protected ExternalDocumentation resolveExternalDocumentation(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        ExternalDocumentation external = null;
        if (a != null) {
            io.swagger.v3.oas.annotations.ExternalDocumentation externalDocumentation = (io.swagger.v3.oas.annotations.ExternalDocumentation)a.getAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
            external = this.resolveExternalDocumentation(externalDocumentation);
        }
        if (external == null && schema != null) {
            external = this.resolveExternalDocumentation(schema.externalDocs());
        }
        return external;
    }

    protected ExternalDocumentation resolveExternalDocumentation(io.swagger.v3.oas.annotations.ExternalDocumentation externalDocumentation) {
        if (externalDocumentation == null) {
            return null;
        }
        boolean isEmpty = true;
        ExternalDocumentation external = new ExternalDocumentation();
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (isEmpty) {
            return null;
        }
        return external;
    }

    protected Boolean resolveDeprecated(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.deprecated()) {
            return schema.deprecated();
        }
        return null;
    }

    protected List<String> resolveAllowableValues(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.allowableValues() != null && schema.allowableValues().length > 0) {
            return Arrays.asList(schema.allowableValues());
        }
        return null;
    }

    protected Map<String, Object> resolveExtensions(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.extensions() != null && schema.extensions().length > 0) {
            return AnnotationsUtils.getExtensions(schema.extensions());
        }
        return null;
    }

    protected void resolveDiscriminatorProperty(JavaType type, ModelConverterContext context, Schema model) {
        String typeInfoProp;
        JsonTypeInfo typeInfo = type.getRawClass().getDeclaredAnnotation(JsonTypeInfo.class);
        if (typeInfo != null && StringUtils.isNotBlank((CharSequence)(typeInfoProp = typeInfo.property()))) {
            Schema modelToUpdate = model;
            if (StringUtils.isNotBlank((CharSequence)model.get$ref())) {
                modelToUpdate = context.getDefinedModels().get(model.get$ref().substring(21));
            }
            if (modelToUpdate.getProperties() == null || !modelToUpdate.getProperties().keySet().contains(typeInfoProp)) {
                Schema discriminatorSchema = new StringSchema().name(typeInfoProp);
                modelToUpdate.addProperties(typeInfoProp, discriminatorSchema);
                if (modelToUpdate.getRequired() == null || !modelToUpdate.getRequired().contains(typeInfoProp)) {
                    modelToUpdate.addRequiredItem(typeInfoProp);
                }
            }
        }
    }

    protected Discriminator resolveDiscriminator(JavaType type, ModelConverterContext context) {
        JsonTypeInfo typeInfo;
        String disc;
        io.swagger.v3.oas.annotations.media.Schema declaredSchemaAnnotation = AnnotationsUtils.getSchemaDeclaredAnnotation(type.getRawClass());
        String string = disc = declaredSchemaAnnotation == null ? "" : declaredSchemaAnnotation.discriminatorProperty();
        if (disc.isEmpty() && (typeInfo = type.getRawClass().getDeclaredAnnotation(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            DiscriminatorMapping[] mappings;
            Discriminator discriminator = new Discriminator().propertyName(disc);
            if (declaredSchemaAnnotation != null && (mappings = declaredSchemaAnnotation.discriminatorMapping()) != null && mappings.length > 0) {
                for (DiscriminatorMapping mapping : mappings) {
                    if (mapping.value().isEmpty() || mapping.schema().equals(Void.class)) continue;
                    discriminator.mapping(mapping.value(), RefUtils.constructRef(context.resolve(new AnnotatedType().type(mapping.schema())).getName()));
                }
            }
            return discriminator;
        }
        return null;
    }

    protected XML resolveXml(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        XmlRootElement rootAnnotation = null;
        if (a != null) {
            rootAnnotation = (XmlRootElement)a.getAnnotation(XmlRootElement.class);
        }
        if (rootAnnotation == null && annotations != null) {
            for (Annotation ann : annotations) {
                if (!(ann instanceof XmlRootElement)) continue;
                rootAnnotation = (XmlRootElement)ann;
                break;
            }
        }
        if (rootAnnotation != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            XML xml = new XML().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            }
            return xml;
        }
        return null;
    }

    protected Integer resolveMinItems(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.minItems() < Integer.MAX_VALUE) {
            return arraySchema.minItems();
        }
        return null;
    }

    protected Integer resolveMaxItems(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.maxItems() > 0) {
            return arraySchema.maxItems();
        }
        return null;
    }

    protected Boolean resolveUniqueItems(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.uniqueItems()) {
            return arraySchema.uniqueItems();
        }
        return null;
    }

    protected Map<String, Object> resolveExtensions(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.extensions() != null && arraySchema.extensions().length > 0) {
            return AnnotationsUtils.getExtensions(arraySchema.extensions());
        }
        return null;
    }

    protected void resolveSchemaMembers(Schema schema, AnnotatedType annotatedType) {
        JavaType type = annotatedType.getType() instanceof JavaType ? (JavaType)annotatedType.getType() : this._mapper.constructType(annotatedType.getType());
        Annotation resolvedSchemaOrArrayAnnotation = AnnotationsUtils.mergeSchemaAnnotations(annotatedType.getCtxAnnotations(), type);
        io.swagger.v3.oas.annotations.media.Schema schemaAnnotation = resolvedSchemaOrArrayAnnotation == null ? null : (resolvedSchemaOrArrayAnnotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? ((io.swagger.v3.oas.annotations.media.ArraySchema)resolvedSchemaOrArrayAnnotation).schema() : (io.swagger.v3.oas.annotations.media.Schema)resolvedSchemaOrArrayAnnotation);
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        AnnotatedClass a = beanDesc.getClassInfo();
        Annotation[] annotations = annotatedType.getCtxAnnotations();
        this.resolveSchemaMembers(schema, (Annotated)a, annotations, schemaAnnotation);
    }

    protected void resolveSchemaMembers(Schema schema, Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schemaAnnotation) {
        Map<String, Object> extensions;
        List<String> allowableValues;
        Boolean deprecated;
        ExternalDocumentation externalDocs;
        Boolean writeOnly;
        List<String> requiredProperties;
        Integer maxProperties;
        Integer minProperties;
        String pattern;
        Boolean exclusiveMaximum;
        Boolean exclusiveMinimum;
        BigDecimal maximum;
        BigDecimal minimum;
        Integer minLength;
        Integer maxLength;
        BigDecimal multipleOf;
        Boolean nullable;
        Boolean readOnly;
        Object example;
        String defaultValue;
        String format;
        String title;
        String description = this.resolveDescription(a, annotations, schemaAnnotation);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            schema.description(description);
        }
        if (StringUtils.isNotBlank((CharSequence)(title = this.resolveTitle(a, annotations, schemaAnnotation)))) {
            schema.title(title);
        }
        if (StringUtils.isNotBlank((CharSequence)(format = this.resolveFormat(a, annotations, schemaAnnotation))) && StringUtils.isBlank((CharSequence)schema.getFormat())) {
            schema.format(format);
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultValue = this.resolveDefaultValue(a, annotations, schemaAnnotation)))) {
            schema.setDefault((Object)defaultValue);
        }
        if ((example = this.resolveExample(a, annotations, schemaAnnotation)) != null) {
            schema.example(example);
        }
        if ((readOnly = this.resolveReadOnly(a, annotations, schemaAnnotation)) != null) {
            schema.readOnly(readOnly);
        }
        if ((nullable = this.resolveNullable(a, annotations, schemaAnnotation)) != null) {
            schema.nullable(nullable);
        }
        if ((multipleOf = this.resolveMultipleOf(a, annotations, schemaAnnotation)) != null) {
            schema.multipleOf(multipleOf);
        }
        if ((maxLength = this.resolveMaxLength(a, annotations, schemaAnnotation)) != null) {
            schema.maxLength(maxLength);
        }
        if ((minLength = this.resolveMinLength(a, annotations, schemaAnnotation)) != null) {
            schema.minLength(minLength);
        }
        if ((minimum = this.resolveMinimum(a, annotations, schemaAnnotation)) != null) {
            schema.minimum(minimum);
        }
        if ((maximum = this.resolveMaximum(a, annotations, schemaAnnotation)) != null) {
            schema.maximum(maximum);
        }
        if ((exclusiveMinimum = this.resolveExclusiveMinimum(a, annotations, schemaAnnotation)) != null) {
            schema.exclusiveMinimum(exclusiveMinimum);
        }
        if ((exclusiveMaximum = this.resolveExclusiveMaximum(a, annotations, schemaAnnotation)) != null) {
            schema.exclusiveMaximum(exclusiveMaximum);
        }
        if (StringUtils.isNotBlank((CharSequence)(pattern = this.resolvePattern(a, annotations, schemaAnnotation)))) {
            schema.pattern(pattern);
        }
        if ((minProperties = this.resolveMinProperties(a, annotations, schemaAnnotation)) != null) {
            schema.minProperties(minProperties);
        }
        if ((maxProperties = this.resolveMaxProperties(a, annotations, schemaAnnotation)) != null) {
            schema.maxProperties(maxProperties);
        }
        if ((requiredProperties = this.resolveRequiredProperties(a, annotations, schemaAnnotation)) != null) {
            for (String prop : requiredProperties) {
                this.addRequiredItem(schema, prop);
            }
        }
        if ((writeOnly = this.resolveWriteOnly(a, annotations, schemaAnnotation)) != null) {
            schema.writeOnly(writeOnly);
        }
        if ((externalDocs = this.resolveExternalDocumentation(a, annotations, schemaAnnotation)) != null) {
            schema.externalDocs(externalDocs);
        }
        if ((deprecated = this.resolveDeprecated(a, annotations, schemaAnnotation)) != null) {
            schema.deprecated(deprecated);
        }
        if ((allowableValues = this.resolveAllowableValues(a, annotations, schemaAnnotation)) != null) {
            for (String prop : allowableValues) {
                schema.addEnumItemObject((Object)prop);
            }
        }
        if ((extensions = this.resolveExtensions(a, annotations, schemaAnnotation)) != null) {
            for (String ext : extensions.keySet()) {
                schema.addExtension(ext, extensions.get(ext));
            }
        }
    }

    protected void addRequiredItem(Schema model, String propName) {
        if (model == null || propName == null || StringUtils.isBlank((CharSequence)propName)) {
            return;
        }
        if (model.getRequired() == null || model.getRequired().isEmpty()) {
            model.addRequiredItem(propName);
        }
        if (model.getRequired().stream().noneMatch(s -> propName.equals(s))) {
            model.addRequiredItem(propName);
        }
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.getName().equals("javax.ws.rs.Response")) {
                return true;
            }
        } else if (type instanceof ResolvedType) {
            ResolvedType rt = (ResolvedType)type;
            this.LOGGER.trace("Can't check class {}, {}", (Object)type, (Object)rt.getRawClass().getName());
            if (rt.getRawClass().equals(Class.class)) {
                return true;
            }
        }
        return false;
    }

    private List<String> getIgnoredProperties(BeanDescription beanDescription) {
        AnnotationIntrospector introspector = this._mapper.getSerializationConfig().getAnnotationIntrospector();
        String[] ignored = introspector.findPropertiesToIgnore((Annotated)beanDescription.getClassInfo(), true);
        return ignored == null ? Collections.emptyList() : Arrays.asList(ignored);
    }

    protected String decorateModelName(AnnotatedType type, String originalName) {
        if (StringUtils.isBlank((CharSequence)originalName)) {
            return originalName;
        }
        String name = originalName;
        if (type.getJsonViewAnnotation() != null && type.getJsonViewAnnotation().value().length > 0) {
            String COMBINER = "-or-";
            StringBuilder sb = new StringBuilder();
            for (Class view : type.getJsonViewAnnotation().value()) {
                sb.append(view.getSimpleName()).append(COMBINER);
            }
            String suffix = sb.substring(0, sb.length() - COMBINER.length());
            name = originalName + "_" + suffix;
        }
        return name;
    }

    protected boolean hiddenByJsonView(Annotation[] annotations, AnnotatedType type) {
        JsonView jsonView = type.getJsonViewAnnotation();
        if (jsonView == null) {
            return false;
        }
        Class[] filters = jsonView.value();
        boolean containsJsonViewAnnotation = false;
        for (Annotation ant : annotations) {
            if (!(ant instanceof JsonView)) continue;
            containsJsonViewAnnotation = true;
            Class[] views = ((JsonView)ant).value();
            for (Class f : filters) {
                for (Class v : views) {
                    if (v != f && !v.isAssignableFrom(f)) continue;
                    return false;
                }
            }
        }
        return containsJsonViewAnnotation;
    }

    private void resolveArraySchema(AnnotatedType annotatedType, ArraySchema schema, io.swagger.v3.oas.annotations.media.ArraySchema resolvedArrayAnnotation) {
        Map<String, Object> extensions;
        Boolean uniqueItems;
        Integer maxItems;
        Integer minItems = this.resolveMinItems(annotatedType, resolvedArrayAnnotation);
        if (minItems != null) {
            schema.minItems(minItems);
        }
        if ((maxItems = this.resolveMaxItems(annotatedType, resolvedArrayAnnotation)) != null) {
            schema.maxItems(maxItems);
        }
        if ((uniqueItems = this.resolveUniqueItems(annotatedType, resolvedArrayAnnotation)) != null) {
            schema.uniqueItems(uniqueItems);
        }
        if ((extensions = this.resolveExtensions(annotatedType, resolvedArrayAnnotation)) != null) {
            schema.extensions(extensions);
        }
        if (resolvedArrayAnnotation != null && AnnotationsUtils.hasSchemaAnnotation(resolvedArrayAnnotation.arraySchema())) {
            this.resolveSchemaMembers((Schema)schema, null, null, resolvedArrayAnnotation.arraySchema());
        }
    }

    private static enum GeneratorWrapper {
        PROPERTY(ObjectIdGenerators.PropertyGenerator.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                JavaType javaType = type.getType() instanceof JavaType ? (JavaType)type.getType() : mapper.constructType(type.getType());
                BeanDescription beanDesc = mapper.getSerializationConfig().introspect(javaType);
                for (BeanPropertyDefinition def : beanDesc.findProperties()) {
                    String name = def.getName();
                    if (name == null || !name.equals(propertyName)) continue;
                    AnnotatedMember propMember = def.getPrimaryMember();
                    JavaType propType = propMember.getType();
                    if (PrimitiveType.fromType((Type)propType) != null) {
                        return PrimitiveType.createProperty((Type)propType);
                    }
                    ArrayList<Annotation> list = new ArrayList<Annotation>();
                    for (Annotation a : propMember.annotations()) {
                        list.add(a);
                    }
                    Annotation[] annotations = list.toArray(new Annotation[list.size()]);
                    Annotation propSchemaOrArray = AnnotationsUtils.mergeSchemaAnnotations(annotations, propType);
                    AnnotatedType aType = new AnnotatedType().type((Type)propType).ctxAnnotations(annotations).jsonViewAnnotation(type.getJsonViewAnnotation()).schemaProperty(true).propertyName(type.getPropertyName());
                    return context.resolve(aType);
                }
                return null;
            }
        }
        ,
        INT(ObjectIdGenerators.IntSequenceGenerator.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                IntegerSchema id = new IntegerSchema();
                return GeneratorWrapper.process((Schema)id, propertyName, type, context);
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return new IntegerSchema();
            }
        }
        ,
        UUID(ObjectIdGenerators.UUIDGenerator.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                UUIDSchema id = new UUIDSchema();
                return GeneratorWrapper.process((Schema)id, propertyName, type, context);
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return new UUIDSchema();
            }
        }
        ,
        NONE(ObjectIdGenerators.None.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }
        };

        private final Class<? extends ObjectIdGenerator> generator;

        private GeneratorWrapper(Class<? extends ObjectIdGenerator> generator) {
            this.generator = generator;
        }

        protected abstract Schema processAsProperty(String var1, AnnotatedType var2, ModelConverterContext var3, ObjectMapper var4);

        protected abstract Schema processAsId(String var1, AnnotatedType var2, ModelConverterContext var3, ObjectMapper var4);

        public static Schema processJsonIdentity(AnnotatedType type, ModelConverterContext context, ObjectMapper mapper, JsonIdentityInfo identityInfo, JsonIdentityReference identityReference) {
            GeneratorWrapper wrapper;
            GeneratorWrapper generatorWrapper = wrapper = identityInfo != null ? GeneratorWrapper.getWrapper(identityInfo.generator()) : null;
            if (wrapper == null) {
                return null;
            }
            if (identityReference != null && identityReference.alwaysAsId()) {
                return wrapper.processAsId(identityInfo.property(), type, context, mapper);
            }
            return wrapper.processAsProperty(identityInfo.property(), type, context, mapper);
        }

        private static GeneratorWrapper getWrapper(Class<?> generator) {
            for (GeneratorWrapper value : GeneratorWrapper.values()) {
                if (!value.generator.isAssignableFrom(generator)) continue;
                return value;
            }
            return null;
        }

        private static Schema process(Schema id, String propertyName, AnnotatedType type, ModelConverterContext context) {
            Schema model;
            Schema mi = model = context.resolve(GeneratorWrapper.removeJsonIdentityAnnotations(type));
            mi.addProperties(propertyName, id);
            return new Schema().$ref(StringUtils.isNotEmpty((CharSequence)mi.get$ref()) ? mi.get$ref() : mi.getName());
        }

        private static AnnotatedType removeJsonIdentityAnnotations(AnnotatedType type) {
            return new AnnotatedType().jsonUnwrappedHandler(type.getJsonUnwrappedHandler()).jsonViewAnnotation(type.getJsonViewAnnotation()).name(type.getName()).parent(type.getParent()).resolveAsRef(false).schemaProperty(type.isSchemaProperty()).skipOverride(type.isSkipOverride()).skipSchemaName(type.isSkipSchemaName()).type(type.getType()).skipJsonIdentity(true).propertyName(type.getPropertyName()).ctxAnnotations(AnnotationsUtils.removeAnnotations(type.getCtxAnnotations(), JsonIdentityInfo.class, JsonIdentityReference.class));
        }
    }
}

