/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.exception.FieldAlreadyExistsException;
import io.github.microserviceapipatterns.protobufgen.exception.FieldNumberAlreadyExistsException;
import io.github.microserviceapipatterns.protobufgen.exception.NestedMessageAlreadyExistsException;
import io.github.microserviceapipatterns.protobufgen.model.FieldType;
import io.github.microserviceapipatterns.protobufgen.model.Identifiable;
import io.github.microserviceapipatterns.protobufgen.model.Identifier;
import io.github.microserviceapipatterns.protobufgen.model.MessageField;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Message
implements FieldType,
Identifiable {
    private Identifier name;
    private String comment;
    private Set<MessageField> fields;
    private List<Message> nestedMessages;
    private Message parent;

    private Message() {
    }

    @Override
    public String getName() {
        return this.isNestedMessage() ? this.parent.getName() + "." + this.name.toString() : this.name.toString();
    }

    public String getSimpleName() {
        return this.name.toString();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public Set<MessageField> getFields() {
        return new TreeSet<MessageField>(this.fields);
    }

    public List<Message> getNestedMessages() {
        return new LinkedList<Message>(this.nestedMessages);
    }

    public boolean isNestedMessage() {
        return this.parent != null;
    }

    public Message getParent() {
        return this.parent;
    }

    protected void setParent(Message parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.name.equals(message.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final Identifier name;
        private final Set<MessageField> messageFields;
        private final List<Message> nestedMessages;
        private String comment;
        private int fieldCounter = 1;
        private Message parent;

        public Builder(String messageName) {
            this.name = new Identifier(messageName);
            this.comment = "";
            this.messageFields = new TreeSet<MessageField>();
            this.nestedMessages = new LinkedList<Message>();
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withField(MessageField messageField) {
            if (this.messageFields.stream().anyMatch(f -> f.getName().equals(messageField.getName()))) {
                throw new FieldAlreadyExistsException(messageField.getName());
            }
            if (this.messageFields.stream().anyMatch(f -> f.getNumber() == messageField.getNumber())) {
                throw new FieldNumberAlreadyExistsException(this.name.toString(), messageField.getNumber());
            }
            this.messageFields.add(messageField);
            this.fieldCounter = messageField.getNumber() + 1;
            return this;
        }

        public Builder withField(MessageField.Builder fieldBuilder) {
            this.withField(fieldBuilder.build());
            return this;
        }

        public Builder withField(FieldType type, String name) {
            this.withField(new MessageField.Builder(type, name, this.fieldCounter).build());
            return this;
        }

        public Builder withNestedMessage(Message message) {
            if (this.nestedMessages.stream().anyMatch(m -> m.getName().equals(message.getName()))) {
                throw new NestedMessageAlreadyExistsException(message.getName());
            }
            this.nestedMessages.add(message);
            return this;
        }

        public Message build() {
            Message message = new Message();
            message.name = this.name;
            message.fields = new TreeSet<MessageField>(this.messageFields);
            message.nestedMessages = new LinkedList<Message>(this.nestedMessages);
            for (Message nested : this.nestedMessages) {
                nested.setParent(message);
            }
            message.comment = this.comment;
            return message;
        }
    }
}

