/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.exception.WrongIdentifierException;
import java.util.Objects;

public class Identifier {
    private static final String IDENT_REGEX = "^[a-zA-Z][a-zA-Z0-9_]*";
    private final String name;

    public Identifier(String name) {
        if (name == null || !name.matches(IDENT_REGEX)) {
            throw new WrongIdentifierException(name);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

